/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.ParserFactory;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.compiler.ProcessorSupport;
import org.beanio.internal.compiler.PropertyAccessorFactory;
import org.beanio.internal.compiler.accessor.AsmAccessorFactory;
import org.beanio.internal.compiler.accessor.ReflectionAccessorFactory;
import org.beanio.internal.config.BeanConfig;
import org.beanio.internal.config.ConstantConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.PropertyConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.SimplePropertyConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.parser.Aggregation;
import org.beanio.internal.parser.ArrayParser;
import org.beanio.internal.parser.Bean;
import org.beanio.internal.parser.CollectionBean;
import org.beanio.internal.parser.CollectionParser;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.Constant;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.Group;
import org.beanio.internal.parser.Iteration;
import org.beanio.internal.parser.MapParser;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.PropertyComponent;
import org.beanio.internal.parser.Record;
import org.beanio.internal.parser.RecordAggregation;
import org.beanio.internal.parser.RecordArray;
import org.beanio.internal.parser.RecordCollection;
import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.RecordMap;
import org.beanio.internal.parser.Segment;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.Stream;
import org.beanio.internal.parser.StreamFormat;
import org.beanio.internal.parser.accessor.MapAccessor;
import org.beanio.internal.parser.message.ResourceBundleMessageFactory;
import org.beanio.internal.util.BeanUtil;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.TypeHandlerFactory;
import org.beanio.internal.util.TypeUtil;
import org.beanio.stream.RecordParserFactory;
import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParserFactorySupport
extends ProcessorSupport
implements ParserFactory {
    private static final String CONSTRUCTOR_PREFIX = "#";
    private static final boolean asmEnabled = "asm".equalsIgnoreCase(Settings.getInstance().getProperty("org.beanio.propertyAccessorFactory"));
    private static final boolean allowProtectedPropertyAccess = "true".equalsIgnoreCase(Settings.getInstance().getProperty("org.beanio.allowProtectedAccess"));
    private static final Component unbound = new Component(){
        {
            this.setName("unbound");
        }
    };
    private Stream stream;
    private String streamFormat;
    private boolean readEnabled = true;
    private boolean writeEnabled = true;
    private TypeHandlerFactory typeHandlerFactory;
    private PropertyAccessorFactory accessorFactory;
    private ClassLoader classLoader;
    private LinkedList<Component> parserStack = new LinkedList();
    private LinkedList<Component> propertyStack = new LinkedList();

    @Override
    public Stream createStream(StreamConfig config) throws BeanIOConfigurationException {
        if (config.getName() == null) {
            throw new BeanIOConfigurationException("stream name not configured");
        }
        this.createPreprocessor(config).process(config);
        this.accessorFactory = asmEnabled ? new AsmAccessorFactory(this.classLoader) : new ReflectionAccessorFactory();
        try {
            this.process(config);
        }
        catch (BeanIOConfigurationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BeanIOConfigurationException("Failed to compile stream '" + config.getName() + "'", ex);
        }
        this.stream.init();
        return this.stream;
    }

    protected Preprocessor createPreprocessor(StreamConfig config) {
        return new Preprocessor(config);
    }

    protected abstract StreamFormat createStreamFormat(StreamConfig var1);

    protected abstract RecordFormat createRecordFormat(RecordConfig var1);

    protected abstract FieldFormat createFieldFormat(FieldConfig var1, Class<?> var2);

    protected void pushParser(Component component) {
        if (!this.parserStack.isEmpty()) {
            this.parserStack.getLast().add(component);
        }
        this.parserStack.addLast(component);
    }

    protected Component popParser() {
        return this.parserStack.removeLast();
    }

    protected void pushProperty(Component component) {
        if (this.isBound() && component != unbound) {
            Component parent = this.propertyStack.getLast();
            switch (((Property)((Object)parent)).type()) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: 
                case 2: 
                case 3: {
                    parent.add(component);
                }
            }
        }
        this.propertyStack.addLast(component);
    }

    protected Property popProperty() {
        Component c = this.propertyStack.removeLast();
        if (c == unbound) {
            return null;
        }
        Property last = (Property)((Object)c);
        if (!this.propertyStack.isEmpty() && last.isIdentifier()) {
            for (int i = this.propertyStack.size() - 1; i >= 0; --i) {
                if (this.propertyStack.get(i) == unbound) continue;
                ((Property)((Object)this.propertyStack.getLast())).setIdentifier(true);
                break;
            }
        }
        return last;
    }

    protected boolean isBound() {
        return !this.propertyStack.isEmpty() && this.propertyStack.getLast() != unbound;
    }

    protected void updateConstructor(Bean bean) {
        int mods;
        ArrayList<Constructor<?>[]> args = null;
        for (Component child : bean.getChildren()) {
            Constructor<?>[] property = (Constructor<?>[])child;
            if (!property.getAccessor().isConstructorArgument()) continue;
            if (args == null) {
                args = new ArrayList<Constructor<?>[]>();
            }
            args.add(property);
        }
        if (args == null) {
            return;
        }
        Collections.sort(args, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o1.getAccessor().getConstructorArgumentIndex() - o2.getAccessor().getConstructorArgumentIndex();
            }
        });
        int count = args.size();
        if (count != ((Property)args.get(count - 1)).getAccessor().getConstructorArgumentIndex() + 1) {
            throw new BeanIOConfigurationException("Missing constructor argument for bean class '" + bean.getType().getName() + "'");
        }
        Constructor<?> constructor = null;
        block1: for (Constructor<?> c : bean.getType().getDeclaredConstructors()) {
            if (c.getParameterTypes().length != count) continue;
            int i = 0;
            for (Class<?> type : c.getParameterTypes()) {
                Property arg = (Property)args.get(i);
                Class<?> argType = arg.getType();
                if (argType.isPrimitive()) {
                    argType = TypeUtil.toWrapperClass(argType);
                }
                if (!TypeUtil.isAssignable(type, argType)) continue block1;
                ++i;
            }
            constructor = c;
            break;
        }
        if (constructor != null && !Modifier.isPublic(mods = constructor.getModifiers())) {
            if (allowProtectedPropertyAccess) {
                constructor.setAccessible(true);
            } else {
                constructor = null;
            }
        }
        if (constructor == null) {
            throw new BeanIOConfigurationException("No suitable constructor found for bean class '" + bean.getType().getName() + "'");
        }
        bean.setConstructor(constructor);
    }

    @Override
    protected void initializeStream(StreamConfig config) throws BeanIOConfigurationException {
        this.streamFormat = config.getFormat();
        StreamFormat format = this.createStreamFormat(config);
        this.stream = new Stream(format);
        String mode = config.getMode();
        if (mode == null || "readwrite".equals(mode)) {
            this.stream.setMode(0);
        } else if ("read".equals(mode)) {
            this.stream.setMode(1);
            this.writeEnabled = false;
        } else if ("write".equals(mode)) {
            this.stream.setMode(2);
            this.readEnabled = false;
        } else {
            throw new BeanIOConfigurationException("Invalid mode '" + mode + "'");
        }
        ResourceBundleMessageFactory messageFactory = new ResourceBundleMessageFactory();
        String bundleName = Settings.getInstance().getProperty("org.beanio." + config.getFormat() + ".messages");
        if (bundleName != null) {
            try {
                messageFactory.setDefaultResourceBundle(ResourceBundle.getBundle(bundleName));
            }
            catch (MissingResourceException ex) {
                throw new BeanIOConfigurationException("Missing default resource bundle '" + bundleName + "' for stream format '" + config.getFormat() + "'", ex);
            }
        }
        if ((bundleName = config.getResourceBundle()) != null) {
            try {
                messageFactory.setResourceBundle(ResourceBundle.getBundle(bundleName));
            }
            catch (MissingResourceException ex) {
                throw new BeanIOConfigurationException("Missing resource bundle '" + bundleName + "'", ex);
            }
        }
        this.stream.setMessageFactory(messageFactory);
        this.stream.setIgnoreUnidentifiedRecords(config.isIgnoreUnidentifiedRecords());
        this.initializeGroup(config);
    }

    @Override
    protected void finalizeStream(StreamConfig config) throws BeanIOConfigurationException {
        this.stream.setLayout((Selector)((Object)this.parserStack.getFirst()));
        this.finalizeGroup(config);
    }

    @Override
    protected void initializeGroup(GroupConfig config) throws BeanIOConfigurationException {
        if (config.getChildren().isEmpty()) {
            throw new BeanIOConfigurationException("At least one record or group is required.");
        }
        Property bean = this.createProperty(config);
        if (config.isBound() && config.isRepeating()) {
            this.initializeGroupIteration(config, bean);
        }
        this.initializeGroupMain(config, bean);
    }

    protected void initializeGroupIteration(GroupConfig config, Property property) {
        RecordAggregation aggregation = this.createRecordAggregation(config, property);
        this.pushParser(aggregation);
        if (property != null || config.getTarget() != null) {
            this.pushProperty(aggregation);
        }
    }

    protected void initializeGroupMain(GroupConfig config, Property property) {
        Group group = new Group();
        group.setName(config.getName());
        group.setMinOccurs(config.getMinOccurs());
        group.setMaxOccurs(config.getMaxOccurs());
        group.setOrder(config.getOrder());
        group.setProperty(property);
        this.pushParser(group);
        if (property != null) {
            this.pushProperty((Component)((Object)property));
        }
    }

    @Override
    protected void finalizeGroup(GroupConfig config) throws BeanIOConfigurationException {
        Property property = this.finalizeGroupMain(config);
        if (config.isBound() && config.isRepeating()) {
            this.finalizeGroupIteration(config, property);
        }
    }

    protected Property finalizeGroupMain(GroupConfig config) {
        Property property = null;
        if (config.getType() != null) {
            property = this.popProperty();
            this.reflectPropertyType(config, property);
        }
        this.finalizeGroup(config, (Group)this.popParser());
        return property;
    }

    protected void finalizeGroupIteration(GroupConfig config, Property property) {
        RecordAggregation aggregation = (RecordAggregation)this.popParser();
        if (config.getType() != null) {
            this.popProperty();
            this.reflectRecordAggregationType(config, aggregation, property);
        }
    }

    protected void finalizeGroup(GroupConfig config, Group group) {
        String target = config.getTarget();
        if (target != null) {
            group.setProperty(this.findTarget(group, target));
        }
    }

    @Override
    protected void initializeRecord(RecordConfig config) throws BeanIOConfigurationException {
        Property bean = this.createProperty(config);
        if (config.isBound() && config.isRepeating()) {
            this.initializeRecordIteration(config, bean);
        }
        this.initializeRecordMain(config, bean);
    }

    protected void initializeRecordIteration(RecordConfig config, Property property) {
        RecordAggregation collection = this.createRecordAggregation(config, property);
        this.pushParser(collection);
        if (property != null || config.getTarget() != null) {
            this.pushProperty(collection);
        }
    }

    protected void initializeRecordMain(RecordConfig config, Property property) {
        Record record = new Record();
        record.setName(config.getName());
        record.setMinOccurs(config.getMinOccurs());
        record.setMaxOccurs(config.getMaxOccurs());
        record.setOptional(config.getMinOccurs() < config.getMaxOccurs());
        record.setRepeating(config.isRepeating());
        record.setSize(config.getMaxSize());
        record.setFormat(this.createRecordFormat(config));
        record.setOrder(config.getOrder());
        record.setIdentifier(config.isIdentifier());
        record.setProperty(property);
        if (property != null) {
            this.pushProperty((Component)((Object)property));
        } else if (config.getTarget() != null) {
            this.pushProperty(unbound);
        }
        this.pushParser(record);
    }

    @Override
    protected void finalizeRecord(RecordConfig config) throws BeanIOConfigurationException {
        Property property = this.finalizeRecordMain(config);
        if (config.isBound() && config.isRepeating()) {
            this.finalizeRecordIteration(config, property);
        }
    }

    protected Property finalizeRecordMain(RecordConfig config) {
        Property property = null;
        Record record = (Record)this.popParser();
        if (config.getType() != null || config.getTarget() != null) {
            property = this.popProperty();
            String target = config.getTarget();
            if (target != null) {
                property = this.findTarget(record, target);
                this.pushProperty((Component)((Object)property));
                this.popProperty();
                record.setProperty(property);
            }
            if (property != null) {
                this.reflectPropertyType(config, property);
            }
        }
        this.finalizeRecord(config, record);
        return property;
    }

    protected void finalizeRecordIteration(RecordConfig config, Property property) {
        String key;
        RecordAggregation aggregation = (RecordAggregation)this.popParser();
        if (config.getType() != null || config.getTarget() != null) {
            this.popProperty();
            this.reflectRecordAggregationType(config, aggregation, property);
        }
        if ((key = config.getKey()) != null) {
            Component c = this.findDescendant("key", (Component)aggregation.getFirst(), key);
            if (c == null) {
                throw new BeanIOConfigurationException("Key '" + key + "' not found");
            }
            Property keyProperty = null;
            if (c instanceof Property) {
                keyProperty = (Property)((Object)c);
            }
            if (keyProperty == null || keyProperty.getType() == null) {
                throw new BeanIOConfigurationException("Key '" + key + "' is not a property");
            }
            ((RecordMap)aggregation).setKey(keyProperty);
        }
    }

    protected void finalizeRecord(RecordConfig config, Record record) {
    }

    private Property findTarget(Component segment, String name) {
        Component c = this.findDescendant("value", segment, name);
        if (c == null) {
            throw new BeanIOConfigurationException("Descendant value '" + name + "' not found");
        }
        Property property = null;
        if (c instanceof Property) {
            property = (Property)((Object)c);
        }
        if (property == null || property.getType() == null) {
            throw new BeanIOConfigurationException("No class defined for value '" + name + "'");
        }
        return property;
    }

    private Component findDescendant(String type, Component c, String name) {
        if (name.equals(c.getName())) {
            return c;
        }
        for (Component child : c.getChildren()) {
            Component match = this.findDescendant(type, child, name);
            if (match == null) continue;
            if (c instanceof Iteration) {
                throw new BeanIOConfigurationException("Referenced component '" + name + "' may not repeat, or belong to a segment that repeats");
            }
            return match;
        }
        return null;
    }

    @Override
    protected final void initializeSegment(SegmentConfig config) throws BeanIOConfigurationException {
        Property bean = this.createProperty(config);
        if (config.isRepeating()) {
            this.initializeSegmentIteration(config, bean);
        }
        this.initializeSegmentMain(config, bean);
    }

    protected void initializeSegmentIteration(SegmentConfig config, Property property) {
        Aggregation aggregation = this.createAggregation(config, property);
        if (config.getOccursRef() != null) {
            org.beanio.internal.parser.Field occurs = this.findDynamicOccurs(this.parserStack.getLast(), config.getOccursRef());
            aggregation.setOccurs(occurs);
        }
        this.pushParser(aggregation);
        if (property != null || config.getTarget() != null) {
            this.pushProperty(aggregation);
        }
    }

    protected void initializeSegmentMain(SegmentConfig config, Property property) {
        String name = config.getName();
        if (name == null) {
            throw new BeanIOConfigurationException("Segment name not set");
        }
        Segment segment = new Segment();
        segment.setName(config.getName());
        segment.setSize(config.getMaxSize());
        segment.setIdentifier(config.isIdentifier());
        segment.setOptional(config.getMinOccurs() < config.getMaxOccurs());
        segment.setRepeating(config.isRepeating());
        segment.setProperty(property);
        segment.setExistencePredetermined(config.getDefaultExistence());
        if (this.isSegmentRequired(config)) {
            this.pushParser(segment);
        }
        if (property != null) {
            this.pushProperty((Component)((Object)property));
        } else if (config.getTarget() != null) {
            this.pushProperty(unbound);
        }
    }

    protected boolean isSegmentRequired(SegmentConfig config) {
        return config.getType() != null || config.getTarget() != null;
    }

    @Override
    protected final void finalizeSegment(SegmentConfig config) throws BeanIOConfigurationException {
        Property property = this.finalizeSegmentMain(config);
        if (config.isRepeating()) {
            this.finalizeSegmentIteration(config, property);
        }
    }

    protected void finalizeSegmentIteration(SegmentConfig config, Property property) {
        String key;
        Aggregation aggregation = (Aggregation)this.popParser();
        if (config.getType() != null || config.getTarget() != null) {
            this.popProperty();
            this.reflectAggregationType(config, aggregation, property);
        }
        if ((key = config.getKey()) != null) {
            Component c = this.findDescendant("key", (Component)aggregation.getFirst(), key);
            if (c == null) {
                throw new BeanIOConfigurationException("Key '" + key + "' not found");
            }
            Property keyProperty = null;
            if (c instanceof Property) {
                keyProperty = (Property)((Object)c);
            }
            if (keyProperty == null || keyProperty.getType() == null) {
                throw new BeanIOConfigurationException("Key '" + key + "' is not a property");
            }
            ((MapParser)aggregation).setKey(keyProperty);
        }
    }

    protected Property finalizeSegmentMain(SegmentConfig config) {
        Property property = null;
        Segment segment = null;
        if (this.isSegmentRequired(config)) {
            segment = (Segment)this.popParser();
            this.finalizeSegment(config, segment);
        }
        if (config.getType() != null || config.getTarget() != null) {
            property = this.popProperty();
            String target = config.getTarget();
            if (target != null) {
                property = this.findTarget(segment, target);
                this.pushProperty((Component)((Object)property));
                this.popProperty();
                segment.setProperty(property);
            }
            if (property != null) {
                this.reflectPropertyType(config, property);
            }
        }
        return property;
    }

    protected void finalizeSegment(SegmentConfig config, Segment segment) {
    }

    @Override
    protected void handleField(FieldConfig config) throws BeanIOConfigurationException {
        if (config.getName() == null) {
            throw new BeanIOConfigurationException("Missing field name");
        }
        org.beanio.internal.parser.Field field = new org.beanio.internal.parser.Field();
        field.setName(config.getLabel());
        field.setIdentifier(config.isIdentifier());
        field.setRequired(config.isRequired());
        field.setTrim(config.isTrim());
        field.setLazy(config.isLazy());
        field.setLiteral(config.getLiteral());
        field.setMinLength(config.getMinLength());
        field.setMaxLength(config.getMaxLength());
        field.setBound(config.isBound());
        try {
            field.setRegex(config.getRegex());
        }
        catch (PatternSyntaxException ex) {
            throw new BeanIOConfigurationException("Invalid regex pattern", ex);
        }
        if (config.getType() != null) {
            Class<?> propertyType = TypeUtil.toType(this.classLoader, config.getType());
            if (propertyType == null) {
                throw new BeanIOConfigurationException("Invalid type or type alias '" + config.getType() + "'");
            }
            field.setPropertyType(propertyType);
        }
        boolean bind = this.isBound() && config.isBound() && !config.isRepeating();
        Aggregation aggregation = null;
        if (config.isRepeating()) {
            aggregation = this.createAggregation(config, field);
            if (config.getOccursRef() != null) {
                org.beanio.internal.parser.Field occurs = this.findDynamicOccurs(this.parserStack.getLast(), config.getOccursRef());
                aggregation.setOccurs(occurs);
            }
            this.pushParser(aggregation);
            if (aggregation.isProperty()) {
                this.pushProperty(aggregation);
            }
        } else if (bind) {
            this.reflectPropertyType(config, field);
        }
        field.setHandler(this.findTypeHandler(config, field));
        field.setDefaultValue(this.parseDefaultValue(field, config.getDefault()));
        field.setFormat(this.createFieldFormat(config, field.getType()));
        this.pushParser(field);
        if (bind) {
            this.pushProperty(field);
            this.popProperty();
        }
        this.popParser();
        if (aggregation != null) {
            this.popParser();
            if (aggregation.isProperty()) {
                this.popProperty();
            }
            this.reflectAggregationType(config, aggregation, field);
        }
    }

    private org.beanio.internal.parser.Field findDynamicOccurs(Component segment, String name) {
        Component c = this.findDescendant("value", segment, name);
        if (c == null || !(c instanceof org.beanio.internal.parser.Field)) {
            throw new BeanIOConfigurationException("Referenced field '" + name + "' not found");
        }
        org.beanio.internal.parser.Field f = (org.beanio.internal.parser.Field)c;
        if (!Number.class.isAssignableFrom(f.getType())) {
            throw new BeanIOConfigurationException("Referenced field '" + name + "' must be assignable to java.lang.Number");
        }
        return f;
    }

    @Override
    protected void handleConstant(ConstantConfig config) throws BeanIOConfigurationException {
        Constant constant = new Constant();
        constant.setName(config.getName());
        constant.setIdentifier(config.isIdentifier());
        Class<?> propertyType = null;
        if (config.getType() != null && (propertyType = TypeUtil.toType(this.classLoader, config.getType())) == null) {
            throw new BeanIOConfigurationException("Invalid type or type alias '" + config.getType() + "'");
        }
        this.reflectPropertyType(config, constant);
        TypeHandler handler = this.findTypeHandler(config, constant);
        String text = config.getValue();
        if (text != null) {
            try {
                constant.setValue(handler.parse(text));
            }
            catch (TypeConversionException ex) {
                throw new BeanIOConfigurationException("Type conversion failed for configured value '" + text + "': " + ex.getMessage(), ex);
            }
        }
        this.pushProperty(constant);
        this.popProperty();
    }

    protected Aggregation createAggregation(PropertyConfig config, Property property) throws BeanIOConfigurationException {
        boolean isMap = false;
        String collection = config.getCollection();
        Class<?> collectionType = null;
        if (collection != null) {
            collectionType = TypeUtil.toAggregationType(collection);
            if (collectionType == null) {
                throw new BeanIOConfigurationException("Invalid collection type or type alias '" + collection + "'");
            }
            isMap = Map.class.isAssignableFrom(collectionType);
            if (isMap && config.getComponentType() == 'F') {
                throw new BeanIOConfigurationException("Map type collections are not supported for fields");
            }
            if (isMap && ((SegmentConfig)config).getKey() == null) {
                throw new BeanIOConfigurationException("Key required for Map type collection");
            }
            collectionType = this.getConcreteAggregationType(collectionType);
        }
        Aggregation aggregation = null;
        aggregation = collectionType == TypeUtil.ARRAY_TYPE ? new ArrayParser() : (isMap ? new MapParser() : new CollectionParser());
        aggregation.setName(config.getLabel());
        if (config.getOccursRef() != null) {
            aggregation.setMinOccurs(config.getMinOccursRef());
            aggregation.setMaxOccurs(config.getMaxOccursRef());
        } else {
            aggregation.setMinOccurs(config.getMinOccurs());
            aggregation.setMaxOccurs(config.getMaxOccurs());
        }
        aggregation.setLazy(config.isLazy());
        aggregation.setType(collectionType);
        return aggregation;
    }

    protected void reflectAggregationType(PropertyConfig config, Aggregation aggregation, Property property) throws BeanIOConfigurationException {
        Class<?> collectionType = aggregation.getType();
        if (collectionType != null) {
            Class<?> reflectedType = this.reflectCollectionType(aggregation, property, config.getGetter(), config.getSetter());
            if (collectionType == TypeUtil.ARRAY_TYPE) {
                Class<Object> arrayType = property.getType();
                if (reflectedType != null) {
                    arrayType = reflectedType.getComponentType();
                    property.setType(arrayType);
                } else if (arrayType == null) {
                    arrayType = String.class;
                }
                ((ArrayParser)aggregation).setArrayType(arrayType);
            }
        }
    }

    protected RecordAggregation createRecordAggregation(PropertyConfig config, Property property) throws BeanIOConfigurationException {
        boolean isMap = false;
        String collection = config.getCollection();
        Class<?> collectionType = null;
        if (collection != null) {
            collectionType = TypeUtil.toAggregationType(collection);
            if (collectionType == null) {
                throw new BeanIOConfigurationException("Invalid collection type or type alias '" + collection + "'");
            }
            isMap = Map.class.isAssignableFrom(collectionType);
            if (isMap && config.getKey() == null) {
                throw new BeanIOConfigurationException("Key required for Map type collection");
            }
            collectionType = this.getConcreteAggregationType(collectionType);
        }
        RecordAggregation aggregation = collectionType == TypeUtil.ARRAY_TYPE ? new RecordArray() : (isMap ? new RecordMap() : new RecordCollection());
        aggregation.setName(config.getName());
        aggregation.setType(collectionType);
        aggregation.setLazy(config.isLazy());
        return aggregation;
    }

    protected void reflectRecordAggregationType(PropertyConfig config, RecordAggregation aggregation, Property property) throws BeanIOConfigurationException {
        Class<?> collectionType = aggregation.getType();
        if (collectionType != null) {
            Class<?> reflectedType = this.reflectCollectionType(aggregation, property, config.getGetter(), config.getSetter());
            if (collectionType == TypeUtil.ARRAY_TYPE) {
                Class<Object> arrayType = property.getType();
                if (reflectedType != null) {
                    arrayType = reflectedType.getComponentType();
                    property.setType(arrayType);
                } else if (arrayType == null) {
                    arrayType = String.class;
                }
                ((RecordArray)aggregation).setArrayType(arrayType);
            }
        }
    }

    protected Class<?> reflectCollectionType(Property iteration, Property property, String getter, String setter) throws BeanIOConfigurationException {
        Class<?> reflectedType;
        if (!this.isBound()) {
            return null;
        }
        Property parent = (Property)((Object)this.propertyStack.getLast());
        switch (parent.type()) {
            case 0: {
                throw new BeanIOConfigurationException("Cannot add property to attribute");
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
            case 3: {
                iteration.setAccessor(new MapAccessor(iteration.getName()));
                return null;
            }
        }
        int construtorArgumentIndex = -1;
        if (setter != null && setter.startsWith(CONSTRUCTOR_PREFIX)) {
            try {
                construtorArgumentIndex = Integer.parseInt(setter.substring(1));
                if (construtorArgumentIndex <= 0) {
                    throw new BeanIOConfigurationException("Invalid setter method");
                }
                --construtorArgumentIndex;
            }
            catch (NumberFormatException ex) {
                throw new BeanIOConfigurationException("Invalid setter method");
            }
            setter = null;
        }
        try {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(iteration.getName(), getter, setter, construtorArgumentIndex >= 0);
            reflectedType = descriptor.getPropertyType();
            iteration.setAccessor(this.accessorFactory.getPropertyAccessor(parent.getType(), descriptor, construtorArgumentIndex));
        }
        catch (BeanIOConfigurationException ex) {
            Field field = this.getField(iteration.getName());
            if (field == null) {
                throw ex;
            }
            reflectedType = field.getType();
            iteration.setAccessor(this.accessorFactory.getPropertyAccessor(parent.getType(), field, construtorArgumentIndex));
        }
        if (reflectedType == null) {
            return null;
        }
        Class<?> type = property.getType();
        if (iteration.getType() == TypeUtil.ARRAY_TYPE) {
            if (!reflectedType.isArray()) {
                throw new BeanIOConfigurationException("Collection type 'array' does not match bean property type '" + reflectedType.getName() + "'");
            }
            Class<?> arrayType = reflectedType.getComponentType();
            if (type == null) {
                property.setType(arrayType);
            } else if (!TypeUtil.isAssignable(arrayType, type)) {
                throw new BeanIOConfigurationException("Configured field array of type '" + type + "' is not assignable to bean property " + "array of type '" + arrayType.getName() + "'");
            }
        } else if (!reflectedType.isAssignableFrom(iteration.getType())) {
            String beanPropertyTypeName = reflectedType.isArray() ? reflectedType.getComponentType().getName() + "[]" : reflectedType.getName();
            throw new BeanIOConfigurationException("Configured collection type '" + iteration.getType().getName() + "' is not assignable to bean property " + "type '" + beanPropertyTypeName + "'");
        }
        return reflectedType;
    }

    protected void reflectPropertyType(PropertyConfig config, Property property) throws BeanIOConfigurationException {
        Class<?> reflectedType;
        if (property.type() == 1) {
            this.updateConstructor((Bean)property);
        }
        if (!this.isBound()) {
            return;
        }
        Property parent = (Property)((Object)this.propertyStack.getLast());
        switch (parent.type()) {
            case 0: {
                throw new BeanIOConfigurationException("Cannot add a property to a simple property");
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return;
            }
            case 3: {
                property.setAccessor(new MapAccessor(config.getName()));
                return;
            }
        }
        String setter = config.getSetter();
        String getter = config.getGetter();
        int construtorArgumentIndex = -1;
        if (setter != null && setter.startsWith(CONSTRUCTOR_PREFIX)) {
            try {
                construtorArgumentIndex = Integer.parseInt(setter.substring(1));
                if (construtorArgumentIndex <= 0) {
                    throw new BeanIOConfigurationException("Invalid setter method");
                }
                --construtorArgumentIndex;
            }
            catch (NumberFormatException ex) {
                throw new BeanIOConfigurationException("Invalid setter method");
            }
            setter = null;
        }
        try {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(config.getName(), getter, setter, construtorArgumentIndex >= 0);
            reflectedType = descriptor.getPropertyType();
            property.setAccessor(this.accessorFactory.getPropertyAccessor(parent.getType(), descriptor, construtorArgumentIndex));
        }
        catch (BeanIOConfigurationException ex) {
            Field field = this.getField(config.getName());
            if (field == null) {
                throw ex;
            }
            reflectedType = field.getType();
            property.setAccessor(this.accessorFactory.getPropertyAccessor(parent.getType(), field, construtorArgumentIndex));
        }
        Class<?> type = property.getType();
        if (type == null) {
            property.setType(reflectedType);
        } else {
            if (reflectedType != null && !TypeUtil.isAssignable(reflectedType, type)) {
                throw new BeanIOConfigurationException("Property type '" + config.getType() + "' is not assignable to bean property " + "type '" + reflectedType.getName() + "'");
            }
            if (reflectedType.isPrimitive()) {
                property.setType(reflectedType);
            }
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String property, String getter, String setter, boolean isConstructorArgument) throws BeanIOConfigurationException {
        Class<?> beanClass = ((Property)((Object)this.propertyStack.getLast())).getType();
        PropertyDescriptor descriptor = null;
        try {
            if (setter != null && getter != null) {
                descriptor = new PropertyDescriptor(property, beanClass, getter, setter);
            } else {
                BeanInfo info = Introspector.getBeanInfo(beanClass);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    if (!pd.getName().equals(property)) continue;
                    descriptor = pd;
                    break;
                }
                if (descriptor == null) {
                    if (setter == null && getter == null && !isConstructorArgument) {
                        throw new BeanIOConfigurationException("No such property '" + property + "' in class '" + beanClass.getName() + "'");
                    }
                    descriptor = new PropertyDescriptor(property, beanClass, getter, setter);
                } else if (setter != null) {
                    if (descriptor.getReadMethod() != null) {
                        getter = descriptor.getReadMethod().getName();
                    }
                    descriptor = new PropertyDescriptor(property, beanClass, getter, setter);
                } else if (getter != null) {
                    if (descriptor.getWriteMethod() != null) {
                        setter = descriptor.getWriteMethod().getName();
                    }
                    descriptor = new PropertyDescriptor(property, beanClass, getter, setter);
                }
            }
            if (!isConstructorArgument && this.isReadEnabled() && descriptor.getWriteMethod() == null) {
                throw new BeanIOConfigurationException("No writeable method for property '" + property + "' in class '" + beanClass.getName() + "'");
            }
            if (this.isWriteEnabled() && descriptor.getReadMethod() == null) {
                throw new BeanIOConfigurationException("No readable method for property '" + property + "' in class '" + beanClass.getName() + "'");
            }
            return descriptor;
        }
        catch (IntrospectionException e) {
            throw new BeanIOConfigurationException("Bean introspection failed: " + e.getMessage(), e);
        }
    }

    protected Field getField(String property) {
        Class<?> beanClass = ((Property)((Object)this.propertyStack.getLast())).getType();
        AnnotatedElement field = null;
        block0: for (Class<?> c = beanClass; field == null && c != null; c = c.getSuperclass()) {
            for (Class<?> clazz : c.getInterfaces()) {
                for (Field f : clazz.getDeclaredFields()) {
                    if (!f.getName().equals(property)) continue;
                    field = f;
                    break;
                }
                if (field != null) break;
            }
            if (c.isInterface()) break;
            for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
                if (!((Field)annotatedElement).getName().equals(property)) continue;
                field = annotatedElement;
                continue block0;
            }
        }
        if (field == null) {
            return null;
        }
        int mod = field.getModifiers();
        if (Modifier.isFinal(mod)) {
            return null;
        }
        if (!Modifier.isPublic(mod)) {
            if (allowProtectedPropertyAccess) {
                field.setAccessible(true);
            } else {
                return null;
            }
        }
        return field;
    }

    private TypeHandler findTypeHandler(SimplePropertyConfig config, Property field) {
        Class<Object> propertyType = field.getType();
        Properties typeHandlerProperties = null;
        if (config.getFormat() != null) {
            typeHandlerProperties = new Properties();
            typeHandlerProperties.put("format", config.getFormat());
        }
        TypeHandler handler = null;
        if (config.getTypeHandlerInstance() != null) {
            handler = config.getTypeHandlerInstance();
        } else if (config.getTypeHandler() != null && (handler = this.typeHandlerFactory.getTypeHandler(config.getTypeHandler(), typeHandlerProperties)) == null) {
            throw new BeanIOConfigurationException("No configured type handler named '" + config.getTypeHandler() + "'");
        }
        if (handler != null) {
            if (propertyType == null) {
                propertyType = handler.getType();
                field.setType(propertyType);
            } else if (!TypeUtil.isAssignable(propertyType, handler.getType())) {
                throw new BeanIOConfigurationException("Field property type '" + propertyType.getName() + "' is not compatible " + "with assigned type handler named '" + config.getTypeHandler() + "'");
            }
        } else {
            if (propertyType == null) {
                propertyType = String.class;
                field.setType(String.class);
            }
            String typeName = config.getType();
            try {
                if (typeName == null) {
                    typeName = propertyType.getName();
                    handler = this.typeHandlerFactory.getTypeHandlerFor(propertyType, this.streamFormat, typeHandlerProperties);
                } else {
                    handler = this.typeHandlerFactory.getTypeHandlerFor(typeName, this.streamFormat, typeHandlerProperties);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new BeanIOConfigurationException(ex.getMessage(), ex);
            }
            if (handler == null) {
                throw new BeanIOConfigurationException("Type handler not found for type '" + typeName + "'");
            }
        }
        return handler;
    }

    protected Property createProperty(PropertyConfig config) {
        Class<?> beanClass = this.getBeanClass(config);
        if (beanClass == null) {
            return null;
        }
        PropertyComponent property = null;
        if (Collection.class.isAssignableFrom(beanClass)) {
            boolean required = this.propertyStack.isEmpty();
            if (config.getComponentType() == 'S') {
                required = config.getMinOccurs() > 0 && !config.isNillable();
            }
            boolean matchNull = !required && new Integer(0).equals(config.getMinOccurs());
            CollectionBean collection = new CollectionBean();
            collection.setName(config.getName());
            collection.setType(beanClass);
            collection.setRequired(required);
            collection.setMatchNull(matchNull);
            property = collection;
        } else {
            boolean required = this.propertyStack.isEmpty();
            boolean matchNull = !required && new Integer(0).equals(config.getMinOccurs());
            Bean bean = new Bean();
            bean.setName(config.getName());
            bean.setType(beanClass);
            bean.setLazy(config.isLazy());
            bean.setRequired(required);
            bean.setMatchNull(matchNull);
            property = bean;
        }
        return property;
    }

    protected Class<?> getBeanClass(PropertyConfig config) {
        Class beanClass = null;
        if (config.getType() != null) {
            if ("map".equals(config.getType())) {
                beanClass = HashMap.class;
            } else if ("list".equals(config.getType()) || "collection".equals(config.getType())) {
                beanClass = ArrayList.class;
            } else if ("set".equals(config.getType())) {
                beanClass = HashSet.class;
            } else {
                try {
                    beanClass = this.classLoader.loadClass(config.getType());
                    if (this.isReadEnabled() && (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers()))) {
                        throw new BeanIOConfigurationException("Class must be concrete unless stream mode is set to 'write'");
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanIOConfigurationException("Invalid bean class '" + config.getType() + "'", ex);
                }
            }
        }
        return beanClass;
    }

    private Class<?> getConcreteAggregationType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type != TypeUtil.ARRAY_TYPE && (type.isInterface() || Modifier.isAbstract(type.getModifiers()))) {
            if (Set.class.isAssignableFrom(type)) {
                return HashSet.class;
            }
            if (Map.class.isAssignableFrom(type)) {
                return LinkedHashMap.class;
            }
            return ArrayList.class;
        }
        return type;
    }

    protected Object parseDefaultValue(org.beanio.internal.parser.Field field, String text) {
        if (text == null) {
            return null;
        }
        TypeHandler handler = field.getHandler();
        if (handler != null) {
            try {
                return handler.parse(text);
            }
            catch (TypeConversionException ex) {
                throw new BeanIOConfigurationException("Type conversion failed for configured default '" + text + "': " + ex.getMessage(), ex);
            }
        }
        return text;
    }

    protected abstract RecordParserFactory getDefaultRecordParserFactory();

    @Override
    public void setTypeHandlerFactory(TypeHandlerFactory typeHandlerFactory) {
        this.typeHandlerFactory = typeHandlerFactory;
    }

    public boolean isReadEnabled() {
        return this.readEnabled;
    }

    public boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    protected RecordParserFactory createRecordParserFactory(StreamConfig config) {
        RecordParserFactory factory;
        BeanConfig<RecordParserFactory> parserFactoryBean = config.getParserFactory();
        if (parserFactoryBean == null) {
            factory = this.getDefaultRecordParserFactory();
        } else if (parserFactoryBean.getInstance() != null) {
            factory = parserFactoryBean.getInstance();
        } else {
            if (parserFactoryBean.getClassName() == null) {
                factory = this.getDefaultRecordParserFactory();
            } else {
                Object object = BeanUtil.createBean(this.classLoader, parserFactoryBean.getClassName());
                if (!RecordParserFactory.class.isAssignableFrom(object.getClass())) {
                    throw new BeanIOConfigurationException("Configured writer factory class '" + parserFactoryBean.getClassName() + "' does not implement RecordWriterFactory");
                }
                factory = (RecordParserFactory)object;
            }
            BeanUtil.configure(factory, parserFactoryBean.getProperties());
        }
        try {
            factory.init();
            return factory;
        }
        catch (IllegalArgumentException ex) {
            throw new BeanIOConfigurationException("Invalid parser setting(s): " + ex.getMessage(), ex);
        }
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

