/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.delimited;

import org.beanio.internal.compiler.flat.FlatParserFactory;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.StreamFormat;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.delimited.DelimitedFieldFormat;
import org.beanio.internal.parser.format.delimited.DelimitedRecordFormat;
import org.beanio.internal.parser.format.delimited.DelimitedStreamFormat;
import org.beanio.stream.RecordParserFactory;
import org.beanio.stream.delimited.DelimitedRecordParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedParserFactory
extends FlatParserFactory {
    @Override
    public StreamFormat createStreamFormat(StreamConfig config) {
        DelimitedStreamFormat format = new DelimitedStreamFormat();
        format.setName(config.getName());
        format.setRecordParserFactory(this.createRecordParserFactory(config));
        return format;
    }

    @Override
    public RecordFormat createRecordFormat(RecordConfig config) {
        DelimitedRecordFormat format = new DelimitedRecordFormat();
        if (config.getMinLength() != null) {
            format.setMinLength(config.getMinLength());
        }
        if (config.getMaxLength() != null) {
            format.setMaxLength(config.getMaxLength());
        }
        if (config.getMinMatchLength() != null) {
            format.setMinMatchLength(config.getMinMatchLength());
        }
        if (config.getMaxMatchLength() != null) {
            format.setMaxMatchLength(config.getMaxMatchLength());
        }
        return format;
    }

    @Override
    public FieldFormat createFieldFormat(FieldConfig config, Class<?> type) {
        DelimitedFieldFormat format = new DelimitedFieldFormat();
        format.setName(config.getName());
        format.setPosition(config.getPosition());
        format.setUntil(config.getUntil() == null ? 0 : config.getUntil());
        if (config.getLength() != null) {
            FieldPadding padding = new FieldPadding();
            padding.setLength(config.getLength());
            padding.setFiller(config.getPadding().charValue());
            padding.setJustify("right".equals(config.getJustify()) ? (char)'R' : 'L');
            padding.setOptional(!config.isRequired());
            padding.setPropertyType(type);
            padding.init();
            format.setPadding(padding);
        }
        format.setLazy(config.getMinOccurs().equals(0));
        return format;
    }

    @Override
    protected RecordParserFactory getDefaultRecordParserFactory() {
        return new DelimitedRecordParserFactory();
    }
}

