/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.beanio.internal.config.BeanIOConfig;
import org.beanio.internal.config.TypeHandlerConfig;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMapping {
    private static final int TYPE_HANDLER_NAMESPACE = 0;
    private String name;
    private String location;
    private XmlMapping parent;
    private Properties properties;
    private BeanIOConfig config = new BeanIOConfig();
    private List<XmlMapping> importList = new LinkedList<XmlMapping>();
    private Map<String, Element> templateMap = new HashMap<String, Element>();

    public XmlMapping() {
    }

    public XmlMapping(String name, String location, XmlMapping parent) {
        this.name = name;
        this.location = location;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public BeanIOConfig getConfiguration() {
        return this.config;
    }

    public XmlMapping getParent() {
        return this.parent;
    }

    public void addImport(XmlMapping child) {
        this.importList.add(child);
    }

    public boolean isLoading(String url) {
        return url.equals(this.location) || this.parent != null && this.parent.isLoading(url);
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addTypeHandlers(List<TypeHandlerConfig> list) {
        for (XmlMapping m : this.importList) {
            m.addTypeHandlers(list);
        }
        list.addAll(this.config.getTypeHandlerList());
    }

    public boolean addTemplate(String name, Element element) {
        if (this.findTemplate(name) != null) {
            return false;
        }
        this.templateMap.put(name, element);
        return true;
    }

    public Element findTemplate(String name) {
        Element template;
        block1: {
            XmlMapping m;
            template = this.templateMap.get(name);
            if (template != null) break block1;
            Iterator<XmlMapping> iterator = this.importList.iterator();
            while (iterator.hasNext() && (template = (m = iterator.next()).findTemplate(name)) == null) {
            }
        }
        return template;
    }

    public boolean isDeclaredGlobalTypeHandler(String name) {
        return this.isDeclared(0, name);
    }

    private boolean isDeclared(int type, String name) {
        switch (type) {
            case 0: {
                for (TypeHandlerConfig handler : this.config.getTypeHandlerList()) {
                    if (!name.equals(handler.getName())) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid namespace");
            }
        }
        for (XmlMapping m : this.importList) {
            if (!m.isDeclared(type, name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

