/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.beanio.stream.csv.CsvParserConfiguration;
import org.beanio.stream.util.CommentReader;

public class CsvReader
implements RecordReader {
    private char delim = (char)44;
    private char quote = (char)34;
    private char endQuote = (char)34;
    private char escapeChar = (char)34;
    private boolean escapeEnabled = true;
    private boolean multilineEnabled = false;
    private boolean whitespaceAllowed = false;
    private boolean unquotedQuotesAllowed = false;
    private CommentReader commentReader = null;
    private transient Reader in;
    private transient String recordText;
    private transient int recordLineNumber;
    private transient int lineNumber = 0;
    private transient boolean skipLF = false;
    private transient List<String> fieldList = new ArrayList<String>();

    public CsvReader(Reader in) {
        this(in, null);
    }

    public CsvReader(Reader in, CsvParserConfiguration config) throws IllegalArgumentException {
        if (config == null) {
            config = new CsvParserConfiguration();
        }
        this.in = in;
        this.delim = config.getDelimiter();
        if (this.delim == ' ') {
            throw new IllegalArgumentException("The CSV field delimiter '" + this.delim + "' is not supported");
        }
        this.endQuote = this.quote = config.getQuote();
        if (this.quote == this.delim) {
            throw new IllegalArgumentException("The CSV field delimiter cannot match the character used for the quotation mark.");
        }
        this.multilineEnabled = config.isMultilineEnabled();
        this.whitespaceAllowed = config.isWhitespaceAllowed();
        this.unquotedQuotesAllowed = config.isUnquotedQuotesAllowed();
        if (config.getEscape() != null) {
            this.escapeEnabled = true;
            this.escapeChar = config.getEscape().charValue();
            if (this.escapeChar == this.delim) {
                throw new IllegalArgumentException("The CSV field delimiter cannot match the escape character.");
            }
        } else {
            this.escapeEnabled = false;
        }
        if (config.isCommentEnabled()) {
            this.commentReader = new CommentReader(in, config.getComments());
        }
    }

    public int getRecordLineNumber() {
        return this.recordLineNumber;
    }

    public String getRecordText() {
        return this.recordText;
    }

    public String[] read() throws IOException, RecordIOException {
        int n;
        int lines;
        if (this.fieldList == null) {
            this.recordText = null;
            this.recordLineNumber = -1;
            return null;
        }
        ++this.lineNumber;
        if (this.commentReader != null && (lines = this.commentReader.skipComments(this.skipLF)) > 0) {
            if (this.commentReader.isEOF()) {
                this.fieldList = null;
                this.recordText = null;
                this.recordLineNumber = -1;
                return null;
            }
            this.lineNumber += lines;
            this.skipLF = this.commentReader.isSkipLF();
        }
        this.recordLineNumber = this.lineNumber;
        this.fieldList.clear();
        int state = 0;
        int whitespace = 0;
        boolean escaped = false;
        boolean eol = false;
        StringBuilder text = new StringBuilder();
        StringBuilder field = new StringBuilder();
        while (!eol && (n = this.in.read()) != -1) {
            char c = (char)n;
            if (this.skipLF) {
                this.skipLF = false;
                if (c == '\n') {
                    if (state != 1) continue;
                    field.append(c);
                    text.append(c);
                    continue;
                }
            }
            if (c != '\n' && c != '\r') {
                text.append(c);
            }
            if (escaped) {
                escaped = false;
                if (c == this.endQuote) {
                    field.append(c);
                    continue;
                }
                if (c == this.escapeChar) {
                    field.append(this.escapeChar);
                    continue;
                }
                if (this.escapeChar == this.endQuote) {
                    this.fieldList.add(field.toString());
                    field = new StringBuilder();
                    state = 10;
                }
            }
            switch (state) {
                case 0: {
                    if (c == this.delim) {
                        this.fieldList.add(this.createWhitespace(whitespace));
                        whitespace = 0;
                        break;
                    }
                    if (c == this.quote) {
                        whitespace = 0;
                        state = 1;
                        break;
                    }
                    if (c == ' ') {
                        if (!this.whitespaceAllowed) {
                            field.append(c);
                            state = 2;
                            break;
                        }
                        ++whitespace;
                        break;
                    }
                    if (c == '\r') {
                        this.fieldList.add("");
                        this.skipLF = true;
                        eol = true;
                        break;
                    }
                    if (c == '\n') {
                        this.fieldList.add("");
                        eol = true;
                        break;
                    }
                    field.append(this.createWhitespace(whitespace));
                    whitespace = 0;
                    field.append(c);
                    state = 2;
                    break;
                }
                case 1: {
                    if (this.escapeEnabled && c == this.escapeChar) {
                        escaped = true;
                        break;
                    }
                    if (c == this.endQuote) {
                        this.fieldList.add(field.toString());
                        field = new StringBuilder();
                        state = 10;
                        break;
                    }
                    if (c == '\r' || c == '\n') {
                        if (this.multilineEnabled) {
                            this.skipLF = c == '\r';
                            ++this.lineNumber;
                            text.append(c);
                            field.append(c);
                            break;
                        }
                        throw new RecordIOException("Expected end quotation character '" + this.endQuote + "' before end of line " + this.lineNumber);
                    }
                    field.append(c);
                    break;
                }
                case 2: {
                    if (c == this.delim) {
                        this.fieldList.add(field.toString());
                        field = new StringBuilder();
                        state = 0;
                        break;
                    }
                    if (c == this.quote && !this.unquotedQuotesAllowed) {
                        this.recover(text);
                        throw new RecordIOException("Quotation character '" + this.quote + "' must be quoted at line " + this.lineNumber);
                    }
                    if (c == '\n') {
                        this.fieldList.add(field.toString());
                        field = new StringBuilder();
                        eol = true;
                        break;
                    }
                    if (c == '\r') {
                        this.skipLF = true;
                        this.fieldList.add(field.toString());
                        field = new StringBuilder();
                        eol = true;
                        break;
                    }
                    field.append(c);
                    break;
                }
                case 10: {
                    if (c == ' ') {
                        if (this.whitespaceAllowed) break;
                        this.recover(text);
                        throw new RecordIOException("Invalid whitespace found outside of quoted field at line " + this.lineNumber);
                    }
                    if (c == this.delim) {
                        state = 0;
                        break;
                    }
                    if (c == '\r') {
                        this.skipLF = true;
                        eol = true;
                        break;
                    }
                    if (c == '\n') {
                        eol = true;
                        break;
                    }
                    this.recover(text);
                    throw new RecordIOException("Invalid character found outside of quoted field at line " + this.lineNumber);
                }
            }
        }
        if (eol) {
            this.recordText = text.toString();
            String[] record = new String[this.fieldList.size()];
            return this.fieldList.toArray(record);
        }
        if (escaped && this.escapeChar == this.endQuote) {
            this.fieldList.add(field.toString());
            state = 10;
        }
        switch (state) {
            case 0: {
                if (whitespace <= 0 && this.fieldList.size() <= 0) break;
                this.fieldList.add(this.createWhitespace(whitespace));
                break;
            }
            case 1: {
                this.fieldList = null;
                this.recordText = null;
                this.recordLineNumber = -1;
                throw new RecordIOException("Expected end quote before end of line at line " + this.lineNumber);
            }
            case 2: {
                this.fieldList.add(field.toString());
                break;
            }
        }
        if (this.fieldList.isEmpty()) {
            this.fieldList = null;
            this.recordText = null;
            this.recordLineNumber = -1;
            return null;
        }
        String[] record = new String[this.fieldList.size()];
        record = this.fieldList.toArray(record);
        this.recordText = text.toString();
        this.fieldList = null;
        return record;
    }

    private void recover(StringBuilder text) throws IOException {
        int n;
        while ((n = this.in.read()) != -1) {
            char c = (char)n;
            if (c == '\n') {
                this.recordText = text.toString();
                return;
            }
            if (c == '\r') {
                this.skipLF = true;
                this.recordText = text.toString();
                return;
            }
            text.append(c);
        }
        this.recordText = text.toString();
        this.fieldList = null;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private String createWhitespace(int size) {
        if (size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            b.append(' ');
        }
        return b.toString();
    }
}

