/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.MetadataParser;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

public abstract class AbstractRepository
implements Repository {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRepository.class);
    protected final Lock lock;
    private final URL repositoryURL;

    public AbstractRepository(Lock lock, URL repoURL) {
        IllegalArgumentAssertion.assertNotNull(lock, "lock");
        IllegalArgumentAssertion.assertNotNull(repoURL, "repoURL");
        this.repositoryURL = repoURL;
        this.lock = lock;
    }

    @Override
    public URL getRepositoryURL() {
        return this.repositoryURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId getLatestAvailable(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        this.lock.tryLock();
        try {
            ArrayList<PatchId> list = new ArrayList<PatchId>(this.queryAvailable(prefix));
            Collections.sort(list);
            PatchId patchId = list.isEmpty() ? null : (PatchId)list.get(list.size() - 1);
            return patchId;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId addArchive(URL fileUrl) throws IOException {
        this.lock.tryLock();
        try {
            PatchId patchId = PatchId.fromURL(fileUrl);
            DataHandler dataHandler = new DataHandler((DataSource)new URLDataSource(fileUrl));
            PatchMetadata metadata = new PatchMetadataBuilder().patchId(patchId).build();
            PatchId patchId2 = this.addArchive(metadata, dataHandler, false);
            return patchId2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId addArchive(URL fileUrl, boolean force) throws IOException {
        this.lock.tryLock();
        try {
            PatchId patchId = PatchId.fromURL(fileUrl);
            DataHandler dataHandler = new DataHandler((DataSource)new URLDataSource(fileUrl));
            PatchMetadata metadata = new PatchMetadataBuilder().patchId(patchId).build();
            PatchId patchId2 = this.addArchive(metadata, dataHandler, force);
            return patchId2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId addArchive(PatchMetadata metadata, DataHandler dataHandler, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(metadata, "metadata");
        IllegalArgumentAssertion.assertNotNull(dataHandler, "dataHandler");
        PatchId patchId = metadata.getPatchId();
        PatchId oneoffId = metadata.getOneoffId();
        Set<PatchId> dependencies = metadata.getDependencies();
        this.lock.tryLock();
        try {
            Patch patch;
            Throwable throwable;
            if (this.queryAvailable(null).contains(patchId)) {
                LOG.warn("Repository already contains {}", (Object)patchId);
                PatchId patchId2 = patchId;
                return patchId2;
            }
            if (oneoffId != null) {
                PatchAssertion.assertNotNull(this.getPatch(oneoffId), "Cannot obtain target patch for: " + oneoffId);
            }
            String message = "Add " + patchId;
            if (oneoffId != null) {
                message = message + " patching " + oneoffId;
            }
            if (!dependencies.isEmpty()) {
                message = message + " with dependencies on " + dependencies;
            }
            LOG.info(message);
            HashMap<Path, Record> combinedPathsMap = new HashMap<Path, Record>();
            for (PatchId auxid : this.queryAvailable(null)) {
                if (patchId.getName().equals(auxid.getName())) continue;
                for (Record record : this.getPatch(auxid).getRecords()) {
                    combinedPathsMap.put(record.getPath(), record);
                }
            }
            Path targetPath = Files.createTempFile("fptmp", ".zip", new FileAttribute[0]);
            File targetFile = targetPath.toFile();
            if (oneoffId == null) {
                Throwable throwable2 = null;
                try (InputStream input = dataHandler.getInputStream();){
                    throwable = null;
                    try (FileOutputStream output = new FileOutputStream(targetFile);){
                        IOUtils.copy(input, output);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable output) {
                    Throwable throwable4 = output;
                    throw output;
                }
            }
            if (oneoffId != null) {
                final Path workspace = Files.createTempDirectory("oneoff-workspace", new FileAttribute[0]);
                try {
                    Throwable throwable5;
                    FileOutputStream fos;
                    File entryFile;
                    String name;
                    ZipEntry entry;
                    DataSource dataSource = this.getDataSource(oneoffId);
                    throwable = null;
                    try (ZipInputStream zipInput = new ZipInputStream(dataSource.getInputStream());){
                        byte[] buffer2 = new byte[65536];
                        entry = zipInput.getNextEntry();
                        while (entry != null) {
                            if (!entry.isDirectory()) {
                                name = entry.getName();
                                entryFile = workspace.resolve(Paths.get(name, new String[0])).toFile();
                                entryFile.getParentFile().mkdirs();
                                fos = new FileOutputStream(entryFile);
                                throwable5 = null;
                                try {
                                    int read = zipInput.read(buffer2);
                                    while (read > 0) {
                                        fos.write(buffer2, 0, read);
                                        read = zipInput.read(buffer2);
                                    }
                                }
                                catch (Throwable read) {
                                    throwable5 = read;
                                    throw read;
                                }
                                finally {
                                    if (fos != null) {
                                        if (throwable5 != null) {
                                            try {
                                                fos.close();
                                            }
                                            catch (Throwable read) {
                                                throwable5.addSuppressed(read);
                                            }
                                        } else {
                                            fos.close();
                                        }
                                    }
                                }
                            }
                            entry = zipInput.getNextEntry();
                        }
                    }
                    catch (Throwable buffer2) {
                        throwable = buffer2;
                        throw buffer2;
                    }
                    zipInput = new ZipInputStream(dataHandler.getInputStream());
                    throwable = null;
                    try {
                        byte[] buffer3 = new byte[65536];
                        entry = zipInput.getNextEntry();
                        while (entry != null) {
                            if (!entry.isDirectory()) {
                                name = entry.getName();
                                entryFile = workspace.resolve(Paths.get(name, new String[0])).toFile();
                                entryFile.getParentFile().mkdirs();
                                fos = new FileOutputStream(entryFile);
                                throwable5 = null;
                                try {
                                    int read = zipInput.read(buffer3);
                                    while (read > 0) {
                                        fos.write(buffer3, 0, read);
                                        read = zipInput.read(buffer3);
                                    }
                                }
                                catch (Throwable throwable6) {
                                    throwable5 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (fos != null) {
                                        if (throwable5 != null) {
                                            try {
                                                fos.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable5.addSuppressed(throwable7);
                                            }
                                        } else {
                                            fos.close();
                                        }
                                    }
                                }
                            }
                            entry = zipInput.getNextEntry();
                        }
                    }
                    catch (Throwable buffer3) {
                        throwable = buffer3;
                        throw buffer3;
                    }
                    finally {
                        if (zipInput != null) {
                            if (throwable != null) {
                                try {
                                    zipInput.close();
                                }
                                catch (Throwable buffer3) {
                                    throwable.addSuppressed(buffer3);
                                }
                            } else {
                                zipInput.close();
                            }
                        }
                    }
                    throwable = null;
                    try (final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(targetFile));){
                        Files.walkFileTree(workspace, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                                Path relpath = workspace.relativize(path);
                                zos.putNextEntry(new ZipEntry(relpath.toString()));
                                try (FileInputStream fis = new FileInputStream(path.toFile());){
                                    IOUtils.copy(fis, zos);
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (Throwable buffer3) {
                        throwable = buffer3;
                        throw buffer3;
                    }
                }
                finally {
                    IOUtils.rmdirs(workspace);
                }
            }
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(targetFile));
            Object object = null;
            try {
                Patch source = MetadataParser.buildPatchFromZip(patchId, Record.Action.INFO, zipInputStream);
                patch = Patch.create(metadata, source.getRecords());
            }
            catch (Throwable source) {
                object = source;
                throw source;
            }
            finally {
                if (zipInputStream != null) {
                    if (object != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable source) {
                            ((Throwable)object).addSuppressed(source);
                        }
                    } else {
                        zipInputStream.close();
                    }
                }
            }
            HashSet<PatchId> hashSet = new HashSet<PatchId>();
            for (Record rec : patch.getRecords()) {
                Record otherRec = (Record)combinedPathsMap.get(rec.getPath());
                if (otherRec == null) continue;
                PatchId otherId = otherRec.getPatchId();
                if (rec.getChecksum().equals(otherRec.getChecksum())) continue;
                message = "Path '" + rec.getPath() + "' already contained in: " + otherId;
                if (force) {
                    LOG.warn(message);
                } else {
                    LOG.error(message);
                }
                hashSet.add(otherId);
            }
            PatchAssertion.assertTrue(force || hashSet.isEmpty(), "Cannot add " + patchId + " because of duplicate paths in " + hashSet);
            object = this.addArchiveInternal(patch, new DataHandler((DataSource)new FileDataSource(targetFile)));
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SmartPatch getSmartPatch(Patch seedPatch, PatchId patchId) {
        this.lock.tryLock();
        try {
            if (patchId == null) {
                IllegalArgumentAssertion.assertNotNull(seedPatch, "seedPatch");
                patchId = this.getLatestAvailable(seedPatch.getPatchId().getName());
            }
            Patch targetSet = this.getPatch(patchId);
            PatchAssertion.assertNotNull(targetSet, "Repository does not contain package: " + patchId);
            Patch smartSet = Patch.smartDelta(seedPatch, targetSet);
            CloseableDataSource dataSource = this.getSmartDataSource(smartSet, patchId);
            DataHandler dataHandler = new DataHandler((DataSource)dataSource);
            SmartPatch smartPatch = SmartPatch.forInstall(smartSet, dataHandler);
            return smartPatch;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private CloseableDataSource getSmartDataSource(Patch smartSet, PatchId patchId) throws IOException {
        final Path targetPath = Files.createTempFile("smart-content", ".zip", new FileAttribute[0]);
        DataSource dataSource = this.getDataSource(patchId);
        try (ZipInputStream zin = new ZipInputStream(dataSource.getInputStream());
             ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(targetPath.toFile()));){
            byte[] buffer = new byte[65536];
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                Record rec = smartSet.getRecord(Paths.get(entry.getName(), new String[0]));
                if (!(entry.isDirectory() || rec == null || rec.getAction() != Record.Action.ADD && rec.getAction() != Record.Action.UPD)) {
                    zout.putNextEntry(new ZipEntry(entry.getName()));
                    int read = zin.read(buffer);
                    while (read > 0) {
                        zout.write(buffer, 0, read);
                        read = zin.read(buffer);
                    }
                }
                entry = zin.getNextEntry();
            }
        }
        FileDataSource datasource = new FileDataSource(targetPath.toFile());
        return new CloseableDataSource((DataSource)datasource){

            @Override
            public void close() throws IOException {
                targetPath.toFile().delete();
            }
        };
    }

    protected abstract PatchId addArchiveInternal(Patch var1, DataHandler var2) throws IOException;

    protected abstract DataSource getDataSource(PatchId var1);

    static abstract class CloseableDataSource
    implements DataSource,
    Closeable {
        private final DataSource delegate;

        CloseableDataSource(DataSource delegate) {
            IllegalArgumentAssertion.assertNotNull(delegate, "delegate");
            this.delegate = delegate;
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }
    }
}

