/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.debug.ODataDebugResponseWrapper;
import org.apache.olingo.odata2.core.ep.BasicEntityProvider;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class DebugInfoBody
implements DebugInfo {
    private final ODataResponse response;
    private final String serviceRoot;
    private final boolean isXml;
    private final boolean isJson;
    private final boolean isText;
    private final boolean isImage;

    public DebugInfoBody(ODataResponse response, String serviceRoot) {
        this.response = response;
        this.serviceRoot = serviceRoot;
        String contentType = response.getContentHeader();
        this.isXml = contentType.contains("xml");
        this.isJson = !this.isXml && contentType.startsWith("application/json");
        this.isText = this.isXml || this.isJson || contentType.startsWith("text/") || contentType.startsWith("application/http") || contentType.startsWith("multipart/mixed");
        this.isImage = !this.isText && contentType.startsWith("image/");
    }

    @Override
    public String getName() {
        return "Body";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        if (this.isJson) {
            jsonStreamWriter.unquotedValue(this.getContentString());
        } else if (this.isText) {
            jsonStreamWriter.stringValue(this.getContentString());
        } else {
            jsonStreamWriter.stringValueRaw(this.getContentString());
        }
    }

    private String getContentString() {
        if (this.response.getEntity() instanceof String) {
            return (String)this.response.getEntity();
        }
        if (this.response.getEntity() instanceof InputStream) {
            InputStream input = (InputStream)this.response.getEntity();
            try {
                return this.isText ? new BasicEntityProvider().readText(input) : Base64.encodeBase64String((byte[])new BasicEntityProvider().readBinary(input));
            }
            catch (EntityProviderException e) {
                return null;
            }
        }
        throw new ClassCastException("Unsupported content entity class: " + this.response.getEntity().getClass().getName());
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        String body = this.getContentString();
        if (this.isImage) {
            writer.append("<img src=\"data:").append(this.response.getContentHeader()).append(";base64,").append(body).append("\" />\n");
        } else {
            writer.append("<pre class=\"code").append(this.isXml ? " xml" : (this.isJson ? " json" : "")).append("\">\n").append(this.isXml || this.isJson ? this.addLinks(ODataDebugResponseWrapper.escapeHtml(this.isXml ? this.formatXml(body) : this.formatJson(body)), this.isXml) : ODataDebugResponseWrapper.escapeHtml(body)).append("</pre>\n");
        }
    }

    private String formatXml(String xml) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult outputTarget = new StreamResult(new StringWriter());
            transformer.transform(new StreamSource(new StringReader(xml)), outputTarget);
            return outputTarget.getWriter().toString();
        }
        catch (TransformerException e) {
            return xml;
        }
    }

    private String formatJson(String json) {
        return new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson(new JsonParser().parse(json));
    }

    private String addLinks(String source, boolean isXml) {
        String debugOption = "odata-debug=html";
        String urlPattern = "(" + (isXml ? "(?:href|src|base)=" : "\"(?:uri|media_src|edit_media|__next)\":\\p{Space}*") + "\")(.+?)\"";
        return (isXml ? source.replaceAll("(xmlns(?::\\p{Alnum}+)?=\")(.+?)\"", "$1<span class=\"ns\">$2</span>\"") : source).replaceAll(urlPattern, "$1<a href=\"" + this.serviceRoot + "$2?" + "odata-debug=html" + "\">$2</a>\"").replaceAll("(<a href=\"" + Pattern.quote(this.serviceRoot) + ')' + Pattern.quote(this.serviceRoot), "$1").replaceAll("<a href=\"(.+?)\\?(.+?)\\?odata-debug=html", "<a href=\"$1?$2&amp;odata-debug=html").replaceAll("&amp;amp;", "&amp;");
    }
}

