/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.producer.TwitterProducer;
import twitter4j.Status;
import twitter4j.StatusUpdate;

public class UserProducer
extends TwitterProducer {
    public UserProducer(TwitterEndpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Status response;
        Object in = exchange.getIn().getBody();
        if (in instanceof StatusUpdate) {
            response = this.updateStatus((StatusUpdate)in);
        } else {
            String s = (String)exchange.getIn().getMandatoryBody(String.class);
            response = this.updateStatus(s);
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody((Object)response);
        }
    }

    private Status updateStatus(StatusUpdate status) throws Exception {
        Status response = this.endpoint.getProperties().getTwitter().updateStatus(status);
        this.log.debug("Updated status: {}", (Object)status);
        this.log.debug("Status id: {}", (Object)response.getId());
        return response;
    }

    private Status updateStatus(String status) throws Exception {
        Status response = this.endpoint.getProperties().getTwitter().updateStatus(status);
        this.log.debug("Updated status: {}", (Object)status);
        this.log.debug("Status id: {}", (Object)response.getId());
        return response;
    }
}

