/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.IOHelper;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsumer.class);
    protected ExecutorService executor;
    private final KafkaEndpoint endpoint;
    private final Processor processor;
    private final Long pollTimeoutMs;
    private final List<KafkaFetchRecords> tasks = new ArrayList<KafkaFetchRecords>();

    public KafkaConsumer(KafkaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
        this.pollTimeoutMs = endpoint.getConfiguration().getPollTimeoutMs();
        if (endpoint.getConfiguration().getBrokers() == null) {
            throw new IllegalArgumentException("BootStrap servers must be specified");
        }
        if (endpoint.getConfiguration().getGroupId() == null) {
            throw new IllegalArgumentException("groupId must not be null");
        }
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createConsumerProperties();
        this.endpoint.updateClassProperties(props);
        props.put("bootstrap.servers", this.endpoint.getConfiguration().getBrokers());
        props.put("group.id", this.endpoint.getConfiguration().getGroupId());
        return props;
    }

    protected void doStart() throws Exception {
        LOG.info("Starting Kafka consumer");
        super.doStart();
        this.executor = this.endpoint.createExecutor();
        for (int i = 0; i < this.endpoint.getConfiguration().getConsumersCount(); ++i) {
            KafkaFetchRecords task = new KafkaFetchRecords(this.endpoint.getConfiguration().getTopic(), i + "", this.getProps());
            this.executor.submit(task);
            this.tasks.add(task);
        }
    }

    protected void doStop() throws Exception {
        LOG.info("Stopping Kafka consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
            } else {
                this.executor.shutdownNow();
            }
            if (!this.executor.isTerminated()) {
                this.tasks.forEach(rec$ -> ((KafkaFetchRecords)rec$).shutdown());
                this.executor.shutdownNow();
            }
        }
        this.tasks.clear();
        this.executor = null;
        super.doStop();
    }

    class KafkaFetchRecords
    implements Runnable {
        private final org.apache.kafka.clients.consumer.KafkaConsumer consumer;
        private final String topicName;
        private final String threadId;
        private final Properties kafkaProps;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KafkaFetchRecords(String topicName, String id, Properties kafkaProps) {
            this.topicName = topicName;
            this.threadId = topicName + "-" + "Thread " + id;
            this.kafkaProps = kafkaProps;
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(org.apache.kafka.clients.consumer.KafkaConsumer.class.getClassLoader());
                this.consumer = new org.apache.kafka.clients.consumer.KafkaConsumer(kafkaProps);
            }
            finally {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOG.info("Subscribing {} to topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.subscribe(Arrays.asList(this.topicName.split(",")));
                if (KafkaConsumer.this.endpoint.getConfiguration().isSeekToBeginning()) {
                    LOG.debug("{} is seeking to the beginning on topic {}", (Object)this.threadId, (Object)this.topicName);
                    this.consumer.poll(100L);
                    this.consumer.seekToBeginning((Collection)this.consumer.assignment());
                }
                while (KafkaConsumer.this.isRunAllowed() && !KafkaConsumer.this.isStoppingOrStopped() && !KafkaConsumer.this.isSuspendingOrSuspended()) {
                    ConsumerRecords allRecords = this.consumer.poll(KafkaConsumer.this.pollTimeoutMs.longValue());
                    for (TopicPartition partition : allRecords.partitions()) {
                        List partitionRecords = allRecords.records(partition);
                        for (ConsumerRecord record : partitionRecords) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("partition = {}, offset = {}, key = {}, value = {}", new Object[]{record.partition(), record.offset(), record.key(), record.value()});
                            }
                            Exchange exchange = KafkaConsumer.this.endpoint.createKafkaExchange(record);
                            try {
                                KafkaConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KafkaConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }
                        if (KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable() == null || KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable().booleanValue()) continue;
                        long partitionLastoffset = ((ConsumerRecord)partitionRecords.get(partitionRecords.size() - 1)).offset();
                        this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastoffset + 1L)));
                    }
                }
                LOG.info("Unsubscribing {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.unsubscribe();
            }
            catch (InterruptException e) {
                KafkaConsumer.this.getExceptionHandler().handleException("Interrupted while consuming " + this.threadId + " from kafka topic", (Throwable)e);
                LOG.info("Unsubscribing {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.unsubscribe();
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                KafkaConsumer.this.getExceptionHandler().handleException("Error consuming " + this.threadId + " from kafka topic", (Throwable)e);
            }
            finally {
                LOG.debug("Closing {} ", (Object)this.threadId);
                IOHelper.close((Closeable)this.consumer);
            }
        }

        private void shutdown() {
            this.consumer.wakeup();
        }
    }
}

