/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwe.JweCompactProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweOutputStream;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

@Priority(value=1001)
public class JweWriterInterceptor
implements WriterInterceptor {
    protected static final Logger LOG = LogUtils.getL7dLogger(JweWriterInterceptor.class);
    private JweEncryptionProvider encryptionProvider;
    private boolean contentTypeRequired = true;
    private boolean useJweOutputStream;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        OutputStream actualOs = ctx.getOutputStream();
        JweHeaders jweHeaders = new JweHeaders();
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider(jweHeaders);
        String ctString = null;
        MediaType contentMediaType = ctx.getMediaType();
        if (this.contentTypeRequired && contentMediaType != null) {
            ctString = "application".equals(contentMediaType.getType()) ? contentMediaType.getSubtype() : JAXRSUtils.mediaTypeToString((MediaType)contentMediaType, (String[])new String[0]);
        }
        if (ctString != null) {
            jweHeaders.setContentType(ctString);
        }
        if (this.useJweOutputStream) {
            JweOutputStream jweOutputStream;
            JweEncryptionOutput encryption = theEncryptionProvider.getEncryptionOutput(new JweEncryptionInput(jweHeaders));
            JoseUtils.traceHeaders((JoseHeaders)encryption.getHeaders());
            try {
                JweCompactProducer.startJweContent((OutputStream)actualOs, (JweHeaders)encryption.getHeaders(), (byte[])encryption.getContentEncryptionKey(), (byte[])encryption.getIv());
            }
            catch (IOException ex) {
                LOG.warning("JWE encryption error");
                throw new JweException(JweException.Error.CONTENT_ENCRYPTION_FAILURE, (Throwable)ex);
            }
            Object wrappedStream = null;
            wrappedStream = jweOutputStream = new JweOutputStream(actualOs, encryption.getCipher(), encryption.getAuthTagProducer());
            if (encryption.isCompressionSupported()) {
                wrappedStream = new DeflaterOutputStream((OutputStream)jweOutputStream);
            }
            ctx.setOutputStream((OutputStream)wrappedStream);
            ctx.proceed();
            this.setJoseMediaType(ctx);
            jweOutputStream.finalFlush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            String jweContent = theEncryptionProvider.encrypt(cos.getBytes(), jweHeaders);
            JoseUtils.traceHeaders((JoseHeaders)jweHeaders);
            this.setJoseMediaType(ctx);
            IOUtils.copy((InputStream)new ByteArrayInputStream(StringUtils.toBytesUTF8((String)jweContent)), (OutputStream)actualOs);
            actualOs.flush();
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType((String)"application/jose");
        ctx.setMediaType(joseMediaType);
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(JweHeaders headers) {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider((JweHeaders)headers, (boolean)true);
    }

    public void setUseJweOutputStream(boolean useJweOutputStream) {
        this.useJweOutputStream = useJweOutputStream;
    }

    public void setEncryptionProvider(JweEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }
}

