/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

public final class ZipkinClientRequestAdapter
implements ClientRequestAdapter {
    private final ZipkinTracer eventNotifier;
    private final String serviceName;
    private final Exchange exchange;
    private final Endpoint endpoint;
    private final String spanName;
    private final String url;

    public ZipkinClientRequestAdapter(ZipkinTracer eventNotifier, String serviceName, Exchange exchange, Endpoint endpoint) {
        this.eventNotifier = eventNotifier;
        this.serviceName = serviceName;
        this.exchange = exchange;
        this.endpoint = endpoint;
        this.spanName = URISupport.sanitizeUri((String)endpoint.getEndpointKey()).toLowerCase(Locale.US);
        this.url = URISupport.sanitizeUri((String)endpoint.getEndpointUri());
    }

    public String getSpanName() {
        return this.spanName;
    }

    public void addSpanIdToRequest(@Nullable SpanId spanId) {
        if (spanId == null) {
            this.exchange.getIn().setHeader("X-B3-Sampled", (Object)"0");
        } else {
            this.exchange.getIn().setHeader("X-B3-Sampled", (Object)"1");
            this.exchange.getIn().setHeader("X-B3-TraceId", (Object)IdConversion.convertToString((long)spanId.traceId));
            this.exchange.getIn().setHeader("X-B3-SpanId", (Object)IdConversion.convertToString((long)spanId.spanId));
            if (spanId.nullableParentId() != null) {
                this.exchange.getIn().setHeader("X-B3-ParentSpanId", (Object)IdConversion.convertToString((long)spanId.nullableParentId()));
            }
        }
    }

    public String getClientServiceName() {
        return this.serviceName;
    }

    public Collection<KeyValueAnnotation> requestAnnotations() {
        KeyValueAnnotation key1 = KeyValueAnnotation.create((String)"camel.client.endpoint.url", (String)this.url);
        KeyValueAnnotation key2 = KeyValueAnnotation.create((String)"camel.client.exchange.id", (String)this.exchange.getExchangeId());
        KeyValueAnnotation key3 = KeyValueAnnotation.create((String)"camel.client.exchange.pattern", (String)this.exchange.getPattern().name());
        KeyValueAnnotation key4 = null;
        if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(this.exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)(this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn()), (String)"", (boolean)streams, (boolean)streams);
            key4 = KeyValueAnnotation.create((String)"camel.client.exchange.message.request.body", (String)body);
            if (cache != null) {
                cache.reset();
            }
        }
        ArrayList<KeyValueAnnotation> list = new ArrayList<KeyValueAnnotation>();
        list.add(key1);
        list.add(key2);
        list.add(key3);
        if (key4 != null) {
            list.add(key4);
        }
        return list;
    }

    public com.twitter.zipkin.gen.Endpoint serverAddress() {
        return null;
    }
}

