/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.impl.remote.DefaultServiceCallProcessor;
import org.apache.camel.impl.remote.RandomServiceCallLoadBalancer;
import org.apache.camel.impl.remote.RoundRobinServiceCallLoadBalancer;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.remote.ServiceCallConfigurationDefinition;
import org.apache.camel.model.remote.ServiceCallDefinition;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ServiceCallLoadBalancer;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

public abstract class DefaultServiceCallProcessorFactory<C, S extends ServiceCallServer>
implements ProcessorFactory {
    @Override
    public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
        return null;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
        return definition instanceof ServiceCallDefinition ? this.createProcessor(routeContext, (ServiceCallDefinition)definition, this.createConfiguration(routeContext)) : null;
    }

    protected Processor createProcessor(RouteContext routeContext, ServiceCallDefinition definition, C cfg) throws Exception {
        String component;
        ServiceCallServerListStrategy<S> sl;
        ServiceCallLoadBalancer<S> lb;
        Set<ServiceCallConfigurationDefinition> set;
        String name = definition.getName();
        String uri = definition.getUri();
        ExchangePattern mep = definition.getPattern();
        ServiceCallConfigurationDefinition config = definition.getServiceCallConfiguration();
        ServiceCallConfigurationDefinition configRef = null;
        if (definition.getServiceCallConfigurationRef() != null && (configRef = CamelContextHelper.lookup(routeContext.getCamelContext(), definition.getServiceCallConfigurationRef(), ServiceCallConfigurationDefinition.class)) == null) {
            routeContext.getCamelContext().getServiceCallConfiguration(definition.getServiceCallConfigurationRef(), ServiceCallConfigurationDefinition.class);
        }
        if (config == null && configRef == null) {
            config = routeContext.getCamelContext().getServiceCallConfiguration(null, ServiceCallConfigurationDefinition.class);
        }
        if (config == null && (set = routeContext.getCamelContext().getRegistry().findByType(ServiceCallConfigurationDefinition.class)).size() == 1) {
            config = set.iterator().next();
        }
        if (config == null && configRef == null) {
            throw new IllegalStateException("The ServiceCall: " + definition + " must be configured before it can be used.");
        }
        if (cfg != null) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (configRef != null) {
                IntrospectionSupport.getProperties(configRef, parameters, null);
            }
            if (config != null) {
                IntrospectionSupport.getProperties(config, parameters, null);
            }
            IntrospectionSupport.setProperties(cfg, parameters);
        }
        if ((lb = this.configureLoadBalancer(cfg, routeContext, definition)) == null && config != null) {
            lb = this.configureLoadBalancer(cfg, routeContext, config);
        }
        if (lb == null && configRef != null) {
            lb = this.configureLoadBalancer(cfg, routeContext, configRef);
        }
        if ((sl = this.configureServerListStrategy(cfg, routeContext, definition)) == null && config != null) {
            sl = this.configureServerListStrategy(cfg, routeContext, config);
        }
        if (sl == null && configRef != null) {
            sl = this.configureServerListStrategy(cfg, routeContext, configRef);
        }
        String string = component = config != null ? config.getComponent() : null;
        if (component == null && configRef != null) {
            component = configRef.getComponent();
        }
        if (ObjectHelper.isNotEmpty(lb) && lb instanceof CamelContextAware) {
            ((CamelContextAware)((Object)lb)).setCamelContext(routeContext.getCamelContext());
        }
        if (ObjectHelper.isNotEmpty(sl) && sl instanceof CamelContextAware) {
            ((CamelContextAware)((Object)sl)).setCamelContext(routeContext.getCamelContext());
        }
        if (sl == null) {
            sl = this.createDefaultServerListStrategy(cfg);
        }
        if (lb == null) {
            lb = this.createDefaultLoadBalancer(cfg);
        }
        Map<String, String> properties = this.configureProperties(routeContext, config, configRef);
        DefaultServiceCallProcessor processor = this.createProcessor(name, component, uri, mep, cfg, properties);
        if (sl != null && processor.getServerListStrategy() == null) {
            processor.setServerListStrategy(sl);
        }
        if (lb != null && processor.getLoadBalancer() == null) {
            processor.setLoadBalancer(lb);
        }
        return processor;
    }

    protected Map<String, String> configureProperties(RouteContext routeContext, ServiceCallConfigurationDefinition config, ServiceCallConfigurationDefinition configRef) throws Exception {
        String value;
        String key;
        HashMap<String, String> answer = new HashMap<String, String>();
        if (config != null && config.getProperties() != null) {
            for (PropertyDefinition prop : config.getProperties()) {
                key = CamelContextHelper.parseText(routeContext.getCamelContext(), prop.getKey());
                value = CamelContextHelper.parseText(routeContext.getCamelContext(), prop.getValue());
                answer.put(key, value);
            }
        }
        if (configRef != null && configRef.getProperties() != null) {
            for (PropertyDefinition prop : configRef.getProperties()) {
                key = CamelContextHelper.parseText(routeContext.getCamelContext(), prop.getKey());
                value = CamelContextHelper.parseText(routeContext.getCamelContext(), prop.getValue());
                answer.put(key, value);
            }
        }
        return answer;
    }

    protected ServiceCallLoadBalancer configureLoadBalancer(C conf, RouteContext routeContext, ServiceCallDefinition sd) throws Exception {
        ServiceCallLoadBalancer lb = null;
        if (sd != null) {
            lb = sd.getLoadBalancer();
            String ref = sd.getLoadBalancerRef();
            if (lb == null && ref != null) {
                lb = this.builtInLoadBalancer(conf, ref).orElseGet(() -> CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), ref, ServiceCallLoadBalancer.class));
            }
        }
        return lb;
    }

    protected ServiceCallLoadBalancer configureLoadBalancer(C conf, RouteContext routeContext, ServiceCallConfigurationDefinition config) throws Exception {
        ServiceCallLoadBalancer lb = config.getLoadBalancer();
        String ref = config.getLoadBalancerRef();
        if (lb == null && ref != null) {
            lb = this.builtInLoadBalancer(conf, ref).orElseGet(() -> CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), ref, ServiceCallLoadBalancer.class));
        }
        return lb;
    }

    protected ServiceCallServerListStrategy configureServerListStrategy(C conf, RouteContext routeContext, ServiceCallDefinition sd) throws Exception {
        ServiceCallServerListStrategy sl = null;
        if (sd != null) {
            sl = sd.getServerListStrategy();
            String ref = sd.getServerListStrategyRef();
            if (sl == null && ref != null) {
                sl = this.builtInServerListStrategy(conf, ref).orElseGet(() -> CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), ref, ServiceCallServerListStrategy.class));
            }
        }
        return sl;
    }

    protected ServiceCallServerListStrategy configureServerListStrategy(C conf, RouteContext routeContext, ServiceCallConfigurationDefinition config) throws Exception {
        ServiceCallServerListStrategy sl = config.getServerListStrategy();
        String ref = config.getServerListStrategyRef();
        if (sl == null && ref != null) {
            sl = this.builtInServerListStrategy(conf, ref).orElseGet(() -> CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), ref, ServiceCallServerListStrategy.class));
        }
        return sl;
    }

    protected Optional<ServiceCallLoadBalancer> builtInLoadBalancer(C conf, String name) throws Exception {
        ServiceCallLoadBalancer<ServiceCallServer> lb = null;
        if (ObjectHelper.equal(name, "random", true)) {
            lb = new RandomServiceCallLoadBalancer();
        } else if (ObjectHelper.equal(name, "roundrobin", true)) {
            lb = new RoundRobinServiceCallLoadBalancer();
        }
        return Optional.ofNullable(lb);
    }

    protected Optional<ServiceCallServerListStrategy> builtInServerListStrategy(C conf, String name) throws Exception {
        return Optional.empty();
    }

    protected DefaultServiceCallProcessor createProcessor(String name, String component, String uri, ExchangePattern mep, C conf, Map<String, String> properties) throws Exception {
        return new DefaultServiceCallProcessor(name, component, uri, mep);
    }

    protected abstract C createConfiguration(RouteContext var1) throws Exception;

    protected ServiceCallLoadBalancer<S> createDefaultLoadBalancer(C conf) throws Exception {
        return new RoundRobinServiceCallLoadBalancer();
    }

    protected ServiceCallServerListStrategy<S> createDefaultServerListStrategy(C conf) throws Exception {
        return null;
    }
}

