/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.beanio.BeanIOException;
import org.beanio.BeanWriter;
import org.beanio.BeanWriterException;
import org.beanio.BeanWriterIOException;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.util.StatefulWriter;
import org.beanio.stream.RecordWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWriterImpl
implements BeanWriter,
StatefulWriter {
    private Selector layout;
    private MarshallingContext context;

    public BeanWriterImpl(MarshallingContext context, Selector layout) {
        this.context = context;
        this.layout = layout;
    }

    @Override
    public void write(Object bean) throws BeanWriterException {
        this.write(null, bean);
    }

    @Override
    public void write(String recordName, Object bean) throws BeanWriterException {
        this.ensureOpen();
        if (recordName == null && bean == null) {
            throw new BeanWriterException("Bean identification failed: a record name or bean object must be provided");
        }
        try {
            this.context.setComponentName(recordName);
            this.context.setBean(bean);
            Selector matched = this.layout.matchNext(this.context);
            if (matched == null) {
                if (recordName != null) {
                    throw new BeanWriterException("Bean identification failed: record name '" + recordName + "' not matched at the current position" + (bean != null ? " for bean class '" + bean.getClass() + "'" : ""));
                }
                throw new BeanWriterException("Bean identification failed: no record or group mapping for bean class '" + bean.getClass() + "' at the current position");
            }
            matched.marshal(this.context);
        }
        catch (IOException e) {
            throw new BeanWriterIOException(e);
        }
        catch (BeanWriterException ex) {
            throw ex;
        }
        catch (BeanIOException ex) {
            throw new BeanWriterException("Fatal BeanIOException caught", ex);
        }
    }

    @Override
    public void flush() throws BeanWriterIOException {
        this.ensureOpen();
        try {
            this.context.getRecordWriter().flush();
        }
        catch (IOException e) {
            throw new BeanWriterIOException(e);
        }
    }

    @Override
    public void close() throws BeanWriterIOException {
        this.ensureOpen();
        try {
            this.context.getRecordWriter().close();
        }
        catch (IOException e) {
            throw new BeanWriterIOException(e);
        }
        finally {
            this.context = null;
            this.layout = null;
        }
    }

    private void ensureOpen() {
        if (this.context == null) {
            throw new BeanWriterIOException("Stream closed");
        }
    }

    @Override
    public void updateState(String namespace, Map<String, Object> state) {
        this.layout.updateState(this.context, namespace + ".m", state);
        RecordWriter writer = this.context.getRecordWriter();
        if (writer instanceof StatefulWriter) {
            ((StatefulWriter)((Object)writer)).updateState(namespace + ".w", state);
        }
    }

    @Override
    public void restoreState(String namespace, Map<String, Object> state) throws IllegalStateException {
        this.layout.restoreState(this.context, namespace + ".m", state);
        RecordWriter writer = this.context.getRecordWriter();
        if (writer instanceof StatefulWriter) {
            ((StatefulWriter)((Object)writer)).restoreState(namespace + ".w", state);
        }
    }

    @Override
    public void debug() {
        this.debug(System.out);
    }

    @Override
    public void debug(PrintStream out) {
        ((Component)((Object)this.layout)).print(out);
    }
}

