/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import org.beanio.internal.parser.format.xml.XmlNode;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlNodeUtil {
    private XmlNodeUtil() {
    }

    public static boolean isNil(Element element) {
        String nil = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
        return "true".equals(nil) || "1".equals(nil);
    }

    public static String getAttribute(Element element, XmlNode definition) {
        if (element == null) {
            return null;
        }
        if (definition.isNamespaceAware()) {
            if (element.hasAttributeNS(definition.getNamespace(), definition.getLocalName())) {
                return element.getAttributeNS(definition.getNamespace(), definition.getLocalName());
            }
        } else if (element.hasAttribute(definition.getLocalName())) {
            return element.getAttribute(definition.getLocalName());
        }
        return null;
    }

    public static String getText(Node node) {
        StringBuilder s = null;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                if (s == null) {
                    s = new StringBuilder();
                }
                s.append(((Text)child).getTextContent());
                continue;
            }
            if (child.getNodeType() != 4) continue;
            if (s == null) {
                s = new StringBuilder();
            }
            s.append(((CDATASection)child).getData());
        }
        return s == null ? null : s.toString();
    }

    public static Element findSibling(Element sibling, XmlNode target) {
        String xmlName = target.getLocalName();
        String xmlNamespace = target.getNamespace();
        Node node = sibling;
        if (node == null) {
            return null;
        }
        while ((node = node.getNextSibling()) != null) {
            String ns;
            Element element;
            if (node.getNodeType() != 1 || !(element = (Element)node).getLocalName().equals(xmlName) || target.isNamespaceAware() && ((ns = element.getNamespaceURI()) == null ? xmlNamespace != null : !ns.equals(xmlNamespace))) continue;
            return element;
        }
        return null;
    }

    public static Element findChild(Node parent, XmlNode target, int offset) {
        Node node = parent;
        if (node != null) {
            node = node.getFirstChild();
        }
        if (node == null) {
            return null;
        }
        String xmlName = target.getLocalName();
        String xmlNamespace = target.getNamespace();
        int count = 0;
        do {
            String ns;
            Element element;
            if (node.getNodeType() != 1 || !(element = (Element)node).getLocalName().equals(xmlName) || target.isNamespaceAware() && ((ns = element.getNamespaceURI()) != null ? !ns.equals(xmlNamespace) : xmlNamespace != null && xmlNamespace.length() != 0)) continue;
            if (count == offset) {
                return element;
            }
            ++count;
        } while ((node = node.getNextSibling()) != null);
        return null;
    }
}

