/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

public class JsonUtil {
    private static final int INT_SIZE = Integer.toString(Integer.MAX_VALUE).length() - 1;

    private JsonUtil() {
    }

    public static Boolean toBoolean(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        if ("true".equals(text)) {
            return Boolean.TRUE;
        }
        if ("false".equals(text)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Cannot parse '" + text + "' into JSON boolean");
    }

    public static Number toNumber(String text) throws NumberFormatException {
        if (text == null) {
            return null;
        }
        boolean fp = false;
        for (char c : text.toCharArray()) {
            if (c != '.' && c != 'e' && c != 'E') continue;
            fp = true;
            break;
        }
        if (fp) {
            Double d = new Double(text);
            if (d.isNaN() || d.isInfinite()) {
                throw new NumberFormatException("Invalid number");
            }
            return d;
        }
        if (text.length() < INT_SIZE) {
            return new Integer(text);
        }
        Long n = new Long(text);
        if ((long)n.intValue() == n) {
            return new Integer(n.intValue());
        }
        return n;
    }
}

