/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HawkAuthorizationScheme;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HmacAlgorithm;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceVerifier;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public abstract class AbstractHawkAccessTokenValidator
implements AccessTokenValidator {
    protected static final String HTTP_VERB = "http.verb";
    protected static final String HTTP_URI = "http.uri";
    private NonceVerifier nonceVerifier;
    private boolean remoteSignatureValidation;

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return Collections.singletonList("Hawk");
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) throws OAuthServiceException {
        Map<String, String> schemeParams = AbstractHawkAccessTokenValidator.getSchemeParameters(authSchemeData);
        AccessTokenValidation atv = this.getAccessTokenValidation(mc, authScheme, authSchemeData, extraProps, schemeParams);
        if (this.isRemoteSignatureValidation()) {
            return atv;
        }
        String macKey = atv.getExtraProps().get("secret");
        String macAlgo = atv.getExtraProps().get("algorithm");
        HttpRequestProperties httpProps = null;
        httpProps = extraProps != null && extraProps.containsKey((Object)HTTP_VERB) && extraProps.containsKey((Object)HTTP_URI) ? new HttpRequestProperties(URI.create((String)extraProps.getFirst((Object)HTTP_URI)), (String)extraProps.getFirst((Object)HTTP_VERB)) : new HttpRequestProperties(mc.getUriInfo().getRequestUri(), mc.getHttpServletRequest().getMethod());
        HawkAuthorizationScheme macAuthInfo = new HawkAuthorizationScheme(httpProps, schemeParams);
        String normalizedString = macAuthInfo.getNormalizedRequestString();
        try {
            HmacAlgorithm hmacAlgo = HmacAlgorithm.toHmacAlgorithm(macAlgo);
            byte[] serverMacData = HmacUtils.computeHmac((String)macKey, (String)hmacAlgo.getJavaName(), (String)normalizedString);
            String clientMacString = schemeParams.get("mac");
            byte[] clientMacData = Base64Utility.decode((String)clientMacString);
            boolean validMac = Arrays.equals(serverMacData, clientMacData);
            if (!validMac) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton("Hawk"));
            }
        }
        catch (Base64Exception e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        this.validateTimestampNonce(macKey, macAuthInfo.getTimestamp(), macAuthInfo.getNonce());
        return atv;
    }

    protected abstract AccessTokenValidation getAccessTokenValidation(MessageContext var1, String var2, String var3, MultivaluedMap<String, String> var4, Map<String, String> var5);

    protected static Map<String, String> getSchemeParameters(String authData) {
        String[] attributePairs = authData.split(",");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributePairs) {
            String[] pairValues = pair.trim().split("=", 2);
            attributeMap.put(pairValues[0].trim(), pairValues[1].trim().replaceAll("\"", ""));
        }
        return attributeMap;
    }

    protected void validateTimestampNonce(String tokenKey, String ts, String nonce) {
        if (this.nonceVerifier != null) {
            this.nonceVerifier.verifyNonce(tokenKey, nonce, ts);
        }
    }

    public void setNonceVerifier(NonceVerifier nonceVerifier) {
        this.nonceVerifier = nonceVerifier;
    }

    public boolean isRemoteSignatureValidation() {
        return this.remoteSignatureValidation;
    }

    public void setRemoteSignatureValidation(boolean remoteSignatureValidation) {
        this.remoteSignatureValidation = remoteSignatureValidation;
    }
}

