/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.consumer;

import java.util.concurrent.ExecutorService;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageHandler
implements MessageListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executor;
    private SjmsEndpoint endpoint;
    private AsyncProcessor processor;
    private Session session;
    private boolean transacted;
    private boolean synchronous = true;
    private Synchronization synchronization;
    private boolean topic;

    public AbstractMessageHandler(SjmsEndpoint endpoint, ExecutorService executor) {
        this.endpoint = endpoint;
        this.executor = executor;
    }

    public AbstractMessageHandler(SjmsEndpoint endpoint, ExecutorService executor, Synchronization synchronization) {
        this.synchronization = synchronization;
        this.endpoint = endpoint;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block11: {
            RuntimeCamelException rce = null;
            try {
                final Exchange exchange = this.getEndpoint().createExchange(message, this.getSession());
                this.log.debug("Processing Exchange.id:{}", (Object)exchange.getExchangeId());
                if (this.isTransacted() && this.synchronization != null) {
                    exchange.addOnCompletion(this.synchronization);
                }
                try {
                    if (this.isTransacted() || this.isSynchronous()) {
                        this.log.debug("Handling synchronous message: {}", exchange.getIn().getBody());
                        this.handleMessage(exchange);
                    } else {
                        this.log.debug("Handling asynchronous message: {}", exchange.getIn().getBody());
                        this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AbstractMessageHandler.this.handleMessage(exchange);
                                }
                                catch (Exception e) {
                                    exchange.setException((Throwable)e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    if (exchange.getException() == null) {
                        exchange.setException((Throwable)e);
                        break block11;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                rce = ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
            finally {
                if (rce == null) break block11;
                throw rce;
            }
        }
    }

    public abstract void handleMessage(Exchange var1);

    public abstract void close();

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public SjmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public AsyncProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(AsyncProcessor processor) {
        this.processor = processor;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSynchronous(boolean async) {
        this.synchronous = async;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public boolean isTopic() {
        return this.topic;
    }
}

