/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUSender;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DataSmResp;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.DataSmCommandTask;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.EnquireLinkCommandTask;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.OutbindCommandTask;
import org.jsmpp.session.SendCommandTask;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.UnbindCommandTask;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.util.IntUtil;
import org.jsmpp.util.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSession.class);
    private static final Random random = new Random();
    private final Map<Integer, PendingResponse<Command>> pendingResponse = new ConcurrentHashMap<Integer, PendingResponse<Command>>();
    private final Sequence sequence = new Sequence(1);
    private final PDUSender pduSender;
    private int pduProcessorDegree = 3;
    private String sessionId = AbstractSession.generateSessionId();
    private int enquireLinkTimer = 5000;
    private long transactionTimer = 2000L;
    protected EnquireLinkSender enquireLinkSender;

    public AbstractSession(PDUSender pduSender) {
        this.pduSender = pduSender;
    }

    protected abstract AbstractSessionContext sessionContext();

    protected abstract Connection connection();

    protected abstract GenericMessageReceiverListener messageReceiverListener();

    protected PDUSender pduSender() {
        return this.pduSender;
    }

    protected Sequence sequence() {
        return this.sequence;
    }

    protected PendingResponse<Command> removePendingResponse(int sequenceNumber) {
        return this.pendingResponse.remove(sequenceNumber);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setEnquireLinkTimer(int enquireLinkTimer) {
        if (this.sessionContext().getSessionState().isBound()) {
            try {
                this.connection().setSoTimeout(enquireLinkTimer);
            }
            catch (IOException e) {
                logger.error("Failed setting so_timeout for session timer", (Throwable)e);
            }
        }
        this.enquireLinkTimer = enquireLinkTimer;
    }

    @Override
    public int getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    @Override
    public void setTransactionTimer(long transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    @Override
    public long getTransactionTimer() {
        return this.transactionTimer;
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionContext().getSessionState();
    }

    protected synchronized boolean isReadPdu() {
        SessionState sessionState = this.getSessionState();
        return sessionState.isBound() || sessionState.equals((Object)SessionState.OPEN) || sessionState.equals((Object)SessionState.OUTBOUND);
    }

    @Override
    public void addSessionStateListener(SessionStateListener listener) {
        if (listener != null) {
            this.sessionContext().addSessionStateListener(listener);
        }
    }

    @Override
    public void removeSessionStateListener(SessionStateListener listener) {
        this.sessionContext().removeSessionStateListener(listener);
    }

    @Override
    public long getLastActivityTimestamp() {
        return this.sessionContext().getLastActivityTimestamp();
    }

    public void setPduProcessorDegree(int pduProcessorDegree) throws IllegalStateException {
        if (!this.getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IllegalStateException("Cannot set PDU processor degree since the PDU dispatcher thread already created");
        }
        this.pduProcessorDegree = pduProcessorDegree;
    }

    public int getPduProcessorDegree() {
        return this.pduProcessorDegree;
    }

    @Override
    public DataSmResult dataShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, RegisteredDelivery registeredDelivery, DataCoding dataCoding, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        DataSmCommandTask task = new DataSmCommandTask(this.pduSender, serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, registeredDelivery, dataCoding, optionalParameters);
        DataSmResp resp = (DataSmResp)this.executeSendCommand(task, this.getTransactionTimer());
        return new DataSmResult(resp.getMessageId(), resp.getOptionalParameters());
    }

    @Override
    public void close() {
        logger.debug("Close session {}", (Object)this.sessionId);
        AbstractSessionContext ctx = this.sessionContext();
        if (!ctx.getSessionState().equals((Object)SessionState.CLOSED)) {
            ctx.close();
            try {
                this.connection().close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (Thread.currentThread() != this.enquireLinkSender) {
            logger.info("Closing enquireLinkSender for session {}", (Object)this.enquireLinkSender, (Object)this.sessionId);
            if (this.enquireLinkSender != null) {
                while (this.enquireLinkSender.isAlive()) {
                    try {
                        this.enquireLinkSender.join();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("Interrupted while waiting for enquireLinkSender thread to exit");
                    }
                }
            }
        }
        logger.debug("Session {} is closed and enquireLinkSender stopped", (Object)this.sessionId);
    }

    private static void validateResponse(Command response) throws NegativeResponseException {
        if (response.getCommandStatus() != 0) {
            throw new NegativeResponseException(response.getCommandStatus());
        }
    }

    protected DataSmResult fireAcceptDataSm(DataSm dataSm) throws ProcessRequestException {
        GenericMessageReceiverListener messageReceiverListener = this.messageReceiverListener();
        if (messageReceiverListener != null) {
            return messageReceiverListener.onAcceptDataSm(dataSm, this);
        }
        throw new ProcessRequestException("MessageReceiverListener hasn't been set yet", 102);
    }

    protected Command executeSendCommand(SendCommandTask task, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        int seqNum = this.sequence.nextValue();
        PendingResponse pendingResp = new PendingResponse(timeout);
        this.pendingResponse.put(seqNum, pendingResp);
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            logger.error("Failed sending " + task.getCommandName() + " command", (Throwable)e);
            if ("enquire_link".equals(task.getCommandName())) {
                logger.info("Tomas: Ignore failure of sending enquire_link, wait to see if connection is restored");
            }
            this.pendingResponse.remove(seqNum);
            this.close();
            throw e;
        }
        try {
            pendingResp.waitDone();
            logger.debug("{} response received for session {}", (Object)task.getCommandName(), (Object)this.sessionId);
        }
        catch (ResponseTimeoutException e) {
            this.pendingResponse.remove(seqNum);
            throw new ResponseTimeoutException("No response after waiting for " + timeout + " millis when executing " + task.getCommandName() + " with sessionId " + this.sessionId + " and sequenceNumber " + seqNum, e);
        }
        catch (InvalidResponseException e) {
            this.pendingResponse.remove(seqNum);
            throw e;
        }
        Object resp = pendingResp.getResponse();
        AbstractSession.validateResponse(resp);
        return resp;
    }

    protected void executeSendCommandWithNoResponse(SendCommandTask task) throws PDUException, IOException {
        int seqNum = this.sequence.nextValue();
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            logger.error("Failed sending " + task.getCommandName() + " command", (Throwable)e);
            this.close();
            throw e;
        }
    }

    private static final synchronized String generateSessionId() {
        return IntUtil.toHexString(random.nextInt());
    }

    protected void sendEnquireLink() throws ResponseTimeoutException, InvalidResponseException, IOException {
        EnquireLinkCommandTask task = new EnquireLinkCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.getTransactionTimer());
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            logger.warn("command_status of response should be always 0", (Throwable)e);
        }
    }

    public void sendOutbind(String systemId, String password) throws IOException {
        if (this.sessionContext().getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IOException("Session " + this.sessionId + " is closed");
        }
        OutbindCommandTask task = new OutbindCommandTask(this.pduSender, systemId, password);
        try {
            this.executeSendCommandWithNoResponse(task);
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
    }

    public void unbind() throws ResponseTimeoutException, InvalidResponseException, IOException {
        if (this.sessionContext().getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IOException("Session " + this.sessionId + " is closed");
        }
        UnbindCommandTask task = new UnbindCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.transactionTimer);
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            logger.warn("Receive non-ok command_status ({}) for unbind_resp", (Object)e.getCommandStatus());
        }
    }

    @Override
    public void unbindAndClose() {
        logger.debug("Unbind and close sesssion {}", (Object)this.sessionId);
        if (this.sessionContext().getSessionState().isBound()) {
            try {
                this.unbind();
            }
            catch (ResponseTimeoutException e) {
                logger.error("Timeout waiting unbind response", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                logger.error("Receive invalid unbind response", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IO error found", (Throwable)e);
            }
        }
        this.close();
    }

    protected void ensureReceivable(String activityName) throws IOException {
        SessionState currentState = this.getSessionState();
        if (!currentState.isReceivable()) {
            throw new IOException("Cannot " + activityName + " while session " + this.sessionId + " in state " + (Object)((Object)currentState));
        }
    }

    protected void ensureTransmittable(String activityName) throws IOException {
        this.ensureTransmittable(activityName, false);
    }

    protected void ensureTransmittable(String activityName, boolean only) throws IOException {
        SessionState currentState = this.getSessionState();
        if (!currentState.isTransmittable() || only && currentState.isReceivable()) {
            throw new IOException("Cannot " + activityName + " while session " + this.sessionId + " in state " + (Object)((Object)currentState));
        }
    }

    protected class EnquireLinkSender
    extends Thread {
        private final AtomicBoolean sendingEnquireLink;

        public EnquireLinkSender() {
            super("EnquireLinkSender: " + AbstractSession.this);
            this.sendingEnquireLink = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Starting EnquireLinkSender for session {}", (Object)AbstractSession.this.sessionId);
            while (AbstractSession.this.isReadPdu()) {
                while (!this.sendingEnquireLink.compareAndSet(true, false) && AbstractSession.this.isReadPdu()) {
                    AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                    synchronized (atomicBoolean) {
                        try {
                            this.sendingEnquireLink.wait(500L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Interrupted");
                        }
                    }
                }
                if (!AbstractSession.this.isReadPdu()) break;
                try {
                    AbstractSession.this.sendEnquireLink();
                }
                catch (ResponseTimeoutException e) {
                    logger.error("EnquireLinkSender.run() ResponseTimeoutException", (Throwable)e);
                    AbstractSession.this.close();
                }
                catch (InvalidResponseException e) {
                    logger.error("EnquireLinkSender.run() InvalidResponseException", (Throwable)e);
                    AbstractSession.this.unbindAndClose();
                }
                catch (IOException e) {
                    logger.error("EnquireLinkSender.run() IOException", (Throwable)e);
                    AbstractSession.this.close();
                }
            }
            logger.debug("EnquireLinkSender stopped for session {}", (Object)AbstractSession.this.sessionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enquireLink() {
            if (this.sendingEnquireLink.compareAndSet(false, true)) {
                AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                synchronized (atomicBoolean) {
                    this.sendingEnquireLink.notify();
                }
            } else {
                logger.debug("Not sending enquire link notify");
            }
        }
    }
}

