/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConfigurationSource
implements PolledConfigurationSource {
    private static Logger log = LoggerFactory.getLogger(JDBCConfigurationSource.class);
    private DataSource datasource;
    private String query;
    private String keyColumnName = "property_key";
    private String valueColumnName = "property_value";

    public JDBCConfigurationSource(DataSource dataSource, String string, String string2, String string3) {
        this.datasource = dataSource;
        this.query = string;
        this.keyColumnName = string2;
        this.valueColumnName = string3;
    }

    @Override
    public PollResult poll(boolean bl, Object object) throws Exception {
        Map<String, Object> map = this.load();
        return PollResult.createFull(map);
    }

    synchronized Map<String, Object> load() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(this.query.toString());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject(this.keyColumnName);
                Object object = resultSet.getObject(this.valueColumnName);
                hashMap.put(string, object);
            }
            this.close(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return hashMap;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    protected Connection getConnection() throws SQLException {
        return this.getDatasource().getConnection();
    }

    private void close(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            log.error("An error occured on closing the ResultSet", (Throwable)sQLException);
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            log.error("An error occured on closing the statement", (Throwable)sQLException);
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            log.error("An error occured on closing the connection", (Throwable)sQLException);
        }
    }
}

