/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.expression.Expression;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.CollectionUtils;

@IntegrationManagedResource
public abstract class AbstractMessageSource<T>
extends AbstractExpressionEvaluator
implements MessageSource<T>,
MessageSourceMetrics,
NamedComponent,
BeanNameAware {
    private final AtomicLong messageCount = new AtomicLong();
    private volatile Map<String, Expression> headerExpressions = Collections.emptyMap();
    private volatile String beanName;
    private volatile String managedType;
    private volatile String managedName;
    private volatile boolean countsEnabled;
    private volatile boolean loggingEnabled = true;

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions != null ? headerExpressions : Collections.emptyMap();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public void setManagedType(String managedType) {
        this.managedType = managedType;
    }

    @Override
    public String getManagedType() {
        return this.managedType;
    }

    @Override
    public void setManagedName(String managedName) {
        this.managedName = managedName;
    }

    @Override
    public String getManagedName() {
        return this.managedName;
    }

    @Override
    public String getComponentName() {
        return this.beanName;
    }

    @Override
    public boolean isCountsEnabled() {
        return this.countsEnabled;
    }

    @Override
    public void setCountsEnabled(boolean countsEnabled) {
        this.countsEnabled = countsEnabled;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public void reset() {
        this.messageCount.set(0L);
    }

    @Override
    public int getMessageCount() {
        return (int)this.messageCount.get();
    }

    @Override
    public long getMessageCountLong() {
        return this.messageCount.get();
    }

    @Override
    public final Message<T> receive() {
        Object message = null;
        Object result = this.doReceive();
        Map<String, Object> headers = this.evaluateHeaders();
        if (result instanceof Message) {
            try {
                message = (Message<Object>)result;
            }
            catch (Exception e) {
                throw new MessagingException("MessageSource returned unexpected type.", (Throwable)e);
            }
            if (!CollectionUtils.isEmpty(headers)) {
                AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().fromMessage(message);
                builder.copyHeaders(headers);
                message = builder.build();
            }
        } else if (result != null) {
            Object payload = null;
            try {
                payload = result;
            }
            catch (Exception e) {
                throw new MessagingException("MessageSource returned unexpected type.", (Throwable)e);
            }
            AbstractIntegrationMessageBuilder<Object> builder = this.getMessageBuilderFactory().withPayload(payload);
            if (!CollectionUtils.isEmpty(headers)) {
                builder.copyHeaders(headers);
            }
            message = builder.build();
        }
        if (this.countsEnabled && message != null) {
            this.messageCount.incrementAndGet();
        }
        return message;
    }

    private Map<String, Object> evaluateHeaders() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Expression> entry : this.headerExpressions.entrySet()) {
            Object headerValue = this.evaluateExpression(entry.getValue());
            if (headerValue == null) continue;
            results.put(entry.getKey(), headerValue);
        }
        return results;
    }

    protected abstract Object doReceive();
}

