/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.advice.AbstractHandleMessageAdvice;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class IdempotentReceiverInterceptor
extends AbstractHandleMessageAdvice
implements BeanFactoryAware {
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private final MessageSelector messageSelector;
    private volatile MessageChannel discardChannel;
    private volatile boolean throwExceptionOnRejection;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;
    private BeanFactory beanFactory;

    public IdempotentReceiverInterceptor(MessageSelector messageSelector) {
        Assert.notNull((Object)messageSelector);
        this.messageSelector = messageSelector;
    }

    public void setTimeout(long timeout) {
        this.messagingTemplate.setSendTimeout(timeout);
    }

    public void setThrowExceptionOnRejection(boolean throwExceptionOnRejection) {
        this.throwExceptionOnRejection = throwExceptionOnRejection;
    }

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    @Override
    protected Object doInvoke(MethodInvocation invocation, Message<?> message) throws Throwable {
        boolean accept = this.messageSelector.accept(message);
        if (!accept) {
            boolean discarded = false;
            if (this.discardChannel != null) {
                this.messagingTemplate.send(this.discardChannel, message);
                discarded = true;
            }
            if (this.throwExceptionOnRejection) {
                throw new MessageRejectedException(message, "IdempotentReceiver '" + this + "' rejected duplicate Message: " + message);
            }
            if (!discarded) {
                invocation.getArguments()[0] = this.getMessageBuilderFactory().fromMessage(message).setHeader("duplicateMessage", true).build();
            } else {
                return null;
            }
        }
        return invocation.proceed();
    }
}

