/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scattergather;

import org.springframework.aop.support.AopUtils;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.channel.HeaderChannelRegistry;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ScatterGatherHandler
extends AbstractReplyProducingMessageHandler
implements Lifecycle {
    private static final String GATHER_RESULT_CHANNEL = "gatherResultChannel";
    private final MessageChannel scatterChannel;
    private final MessageHandler gatherer;
    private MessageChannel gatherChannel;
    private long gatherTimeout = -1L;
    private AbstractEndpoint gatherEndpoint;
    private HeaderChannelRegistry replyChannelRegistry;

    public ScatterGatherHandler(MessageChannel scatterChannel, MessageHandler gatherer) {
        Assert.notNull((Object)scatterChannel);
        Assert.notNull((Object)gatherer);
        Class gathererClass = AopUtils.getTargetClass((Object)gatherer);
        this.checkClass(gathererClass, "org.springframework.integration.aggregator.AggregatingMessageHandler", "gatherer");
        this.scatterChannel = scatterChannel;
        this.gatherer = gatherer;
    }

    public ScatterGatherHandler(MessageHandler scatterer, MessageHandler gatherer) {
        this((MessageChannel)new FixedSubscriberChannel(scatterer), gatherer);
        Assert.notNull((Object)scatterer);
        Class scattererClass = AopUtils.getTargetClass((Object)scatterer);
        this.checkClass(scattererClass, "org.springframework.integration.router.RecipientListRouter", "scatterer");
    }

    public void setGatherChannel(MessageChannel gatherChannel) {
        this.gatherChannel = gatherChannel;
    }

    public void setGatherTimeout(long gatherTimeout) {
        this.gatherTimeout = gatherTimeout;
    }

    @Override
    protected void doInit() {
        if (this.gatherChannel == null) {
            this.gatherChannel = new FixedSubscriberChannel(this.gatherer);
        } else {
            if (this.gatherChannel instanceof SubscribableChannel) {
                this.gatherEndpoint = new EventDrivenConsumer((SubscribableChannel)this.gatherChannel, this.gatherer);
            } else if (this.gatherChannel instanceof PollableChannel) {
                this.gatherEndpoint = new PollingConsumer((PollableChannel)this.gatherChannel, this.gatherer);
                ((PollingConsumer)this.gatherEndpoint).setReceiveTimeout(this.gatherTimeout);
            } else {
                throw new MessagingException("Unsupported 'replyChannel' type [" + this.gatherChannel.getClass() + "].SubscribableChannel or PollableChannel type are supported.");
            }
            this.gatherEndpoint.setBeanFactory(this.getBeanFactory());
            this.gatherEndpoint.afterPropertiesSet();
        }
        ((MessageProducer)this.gatherer).setOutputChannel((MessageChannel)new FixedSubscriberChannel(new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                MessageHeaders headers = message.getHeaders();
                if (headers.containsKey((Object)ScatterGatherHandler.GATHER_RESULT_CHANNEL)) {
                    Object gatherResultChannel = headers.get((Object)ScatterGatherHandler.GATHER_RESULT_CHANNEL);
                    if (gatherResultChannel instanceof MessageChannel) {
                        ScatterGatherHandler.this.messagingTemplate.send((MessageChannel)gatherResultChannel, message);
                    } else if (gatherResultChannel instanceof String) {
                        ScatterGatherHandler.this.messagingTemplate.send((String)gatherResultChannel, message);
                    }
                } else {
                    throw new MessageDeliveryException(message, "The 'gatherResultChannel' header is required to delivery gather result.");
                }
            }
        }));
        this.replyChannelRegistry = (HeaderChannelRegistry)this.getBeanFactory().getBean("integrationHeaderChannelRegistry", HeaderChannelRegistry.class);
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        QueueChannel gatherResultChannel = new QueueChannel();
        Object gatherResultChannelName = this.replyChannelRegistry.channelToChannelName(gatherResultChannel);
        Message<?> scatterMessage = this.getMessageBuilderFactory().fromMessage(requestMessage).setHeader(GATHER_RESULT_CHANNEL, gatherResultChannelName).setReplyChannel(this.gatherChannel).build();
        this.messagingTemplate.send(this.scatterChannel, scatterMessage);
        Message gatherResult = gatherResultChannel.receive(this.gatherTimeout);
        if (gatherResult != null) {
            return gatherResult.getPayload();
        }
        return null;
    }

    public void start() {
        if (this.gatherEndpoint != null) {
            this.gatherEndpoint.start();
        }
    }

    public void stop() {
        if (this.gatherEndpoint != null) {
            this.gatherEndpoint.start();
        }
    }

    public boolean isRunning() {
        return this.gatherEndpoint == null || this.gatherEndpoint.isRunning();
    }

    private void checkClass(Class<?> gathererClass, String className, String type) throws LinkageError {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.isAssignable((Class)clazz, gathererClass, (String)("the '" + type + "' must be an " + className + " instance"));
    }
}

