/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.selector;

import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MetadataStoreSelector
implements MessageSelector {
    private final ConcurrentMetadataStore metadataStore;
    private final MessageProcessor<String> keyStrategy;
    private final MessageProcessor<String> valueStrategy;

    public MetadataStoreSelector(MessageProcessor<String> keyStrategy) {
        this(keyStrategy, (MessageProcessor<String>)null);
    }

    public MetadataStoreSelector(MessageProcessor<String> keyStrategy, MessageProcessor<String> valueStrategy) {
        this(keyStrategy, valueStrategy, new SimpleMetadataStore());
    }

    public MetadataStoreSelector(MessageProcessor<String> keyStrategy, ConcurrentMetadataStore metadataStore) {
        this(keyStrategy, null, metadataStore);
    }

    public MetadataStoreSelector(MessageProcessor<String> keyStrategy, MessageProcessor<String> valueStrategy, ConcurrentMetadataStore metadataStore) {
        Assert.notNull(keyStrategy);
        Assert.notNull((Object)metadataStore);
        this.metadataStore = metadataStore;
        this.keyStrategy = keyStrategy;
        this.valueStrategy = valueStrategy;
    }

    @Override
    public boolean accept(Message<?> message) {
        String key = this.keyStrategy.processMessage(message);
        String value = this.valueStrategy != null ? this.valueStrategy.processMessage(message) : Long.toString(message.getHeaders().getTimestamp());
        return this.metadataStore.putIfAbsent(key, value) == null;
    }
}

