/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.leader;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.util.Assert;

public class LockRegistryLeaderInitiator
implements SmartLifecycle,
DisposableBean,
ApplicationEventPublisherAware {
    public static final long DEFAULT_HEART_BEAT_TIME = 500L;
    public static final long DEFAULT_BUSY_WAIT_TIME = 50L;
    private static final Log logger = LogFactory.getLog(LockRegistryLeaderInitiator.class);
    private static int threadNameCount = 0;
    private static final Context NULL_CONTEXT = new NullContext();
    private final Object lifecycleMonitor = new Object();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "lock-leadership-" + threadNameCount++);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final LockRegistry locks;
    private final Candidate candidate;
    private long heartBeatMillis = 500L;
    private long busyWaitMillis = 50L;
    private LeaderSelector leaderSelector;
    private ApplicationEventPublisher applicationEventPublisher;
    private LeaderEventPublisher leaderEventPublisher;
    private volatile Future<?> future;
    private volatile boolean autoStartup = true;
    private volatile int phase;
    private volatile boolean running;

    public LockRegistryLeaderInitiator(LockRegistry locks) {
        this(locks, new DefaultCandidate());
    }

    public LockRegistryLeaderInitiator(LockRegistry locks, Candidate candidate) {
        Assert.notNull((Object)locks, (String)"'locks' must not be null");
        Assert.notNull((Object)candidate, (String)"'candidate' must not be null");
        this.locks = locks;
        this.candidate = candidate;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setHeartBeatMillis(long heartBeatMillis) {
        this.heartBeatMillis = heartBeatMillis;
    }

    public void setBusyWaitMillis(long busyWaitMillis) {
        this.busyWaitMillis = busyWaitMillis;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        this.leaderEventPublisher = leaderEventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Context getContext() {
        if (this.leaderSelector == null) {
            return NULL_CONTEXT;
        }
        return this.leaderSelector.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.leaderEventPublisher == null && this.applicationEventPublisher != null) {
            this.leaderEventPublisher = new DefaultLeaderEventPublisher(this.applicationEventPublisher);
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running) {
                this.leaderSelector = new LeaderSelector(this.buildLeaderPath());
                this.future = this.executorService.submit(this.leaderSelector);
                this.running = true;
                logger.debug((Object)"Started LeaderInitiator");
            }
        }
    }

    public void destroy() throws Exception {
        this.stop();
        this.executorService.shutdown();
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                if (this.future != null) {
                    this.future.cancel(true);
                }
                this.future = null;
                logger.debug((Object)"Stopped LeaderInitiator");
            }
        }
    }

    private String buildLeaderPath() {
        return this.candidate.getRole();
    }

    private static final class NullContext
    implements Context {
        private NullContext() {
        }

        @Override
        public boolean isLeader() {
            return false;
        }

        @Override
        public void yield() {
        }
    }

    private class LockContext
    implements Context {
        private LockContext() {
        }

        @Override
        public boolean isLeader() {
            return LockRegistryLeaderInitiator.this.leaderSelector.isLeader();
        }

        @Override
        public void yield() {
            if (LockRegistryLeaderInitiator.this.future != null) {
                LockRegistryLeaderInitiator.this.future.cancel(true);
                if (LockRegistryLeaderInitiator.this.isRunning()) {
                    LockRegistryLeaderInitiator.this.future = LockRegistryLeaderInitiator.this.executorService.submit(LockRegistryLeaderInitiator.this.leaderSelector);
                }
            }
        }

        public String toString() {
            return "LockContext{role=" + LockRegistryLeaderInitiator.this.candidate.getRole() + ", id=" + LockRegistryLeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }

    protected class LeaderSelector
    implements Callable<Void> {
        private final Lock lock;
        private final String lockKey;
        private final LockContext context;
        private volatile boolean locked;

        LeaderSelector(String lockKey) {
            this.context = new LockContext();
            this.locked = false;
            this.lock = LockRegistryLeaderInitiator.this.locks.obtain(lockKey);
            this.lockKey = lockKey;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws Exception {
            block6: while (true) {
                while (LockRegistryLeaderInitiator.this.running) {
                    try {
                        boolean acquired = this.lock.tryLock(LockRegistryLeaderInitiator.this.heartBeatMillis, TimeUnit.MILLISECONDS);
                        if (!this.locked) {
                            if (!acquired) continue block6;
                            this.locked = true;
                            LockRegistryLeaderInitiator.this.candidate.onGranted(this.context);
                            if (LockRegistryLeaderInitiator.this.leaderEventPublisher == null) continue block6;
                            LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnGranted(LockRegistryLeaderInitiator.this, this.context, this.lockKey);
                            continue block6;
                        }
                        if (acquired) {
                            this.lock.unlock();
                            Thread.sleep(LockRegistryLeaderInitiator.this.heartBeatMillis);
                            continue block6;
                        }
                        Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                    }
                    catch (InterruptedException e) {
                        if (this.locked) {
                            this.lock.unlock();
                            this.locked = false;
                            LockRegistryLeaderInitiator.this.candidate.onRevoked(this.context);
                            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                                LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnRevoked(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                            }
                            Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                            Thread.currentThread().interrupt();
                            Void void_ = null;
                            this.lock.unlock();
                            if (this.locked) {
                                LockRegistryLeaderInitiator.this.candidate.onRevoked(this.context);
                                if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnRevoked(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                                }
                            }
                            this.locked = false;
                            return void_;
                        }
                        try {
                            continue block6;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
            finally {
                this.lock.unlock();
                if (this.locked) {
                    LockRegistryLeaderInitiator.this.candidate.onRevoked(this.context);
                    if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                        LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnRevoked(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                    }
                }
                this.locked = false;
            }
        }

        public boolean isLeader() {
            return this.locked;
        }
    }
}

