/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.springframework.integration.support.management.ExponentialMovingAverage;
import org.springframework.integration.support.management.Statistics;

public class ExponentialMovingAverageRate {
    private volatile double min = Double.MAX_VALUE;
    private volatile double max;
    private volatile double t0;
    private volatile long count;
    private final double lapse;
    private final double period;
    private final Deque<Long> times = new ArrayDeque<Long>();
    private final int retention;
    private final int window;
    private final double factor;

    public ExponentialMovingAverageRate(double period, double lapsePeriod, int window) {
        this(period, lapsePeriod, window, false);
    }

    public ExponentialMovingAverageRate(double period, double lapsePeriod, int window, boolean millis) {
        this.lapse = lapsePeriod > 0.0 ? 0.001 / lapsePeriod : 0.0;
        this.period = period * 1000.0;
        this.window = window;
        this.retention = window * 5;
        this.factor = millis ? 1000000.0 : 1.0;
        this.t0 = (double)System.nanoTime() / this.factor;
    }

    public synchronized void reset() {
        this.min = Double.MAX_VALUE;
        this.max = 0.0;
        this.count = 0L;
        this.times.clear();
        this.t0 = (double)System.nanoTime() / this.factor;
    }

    public synchronized void increment() {
        this.increment(System.nanoTime());
    }

    public synchronized void increment(long t) {
        if (this.times.size() == this.retention) {
            this.times.poll();
        }
        this.times.add(t);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics calc() {
        long count;
        ArrayList<Long> copy;
        ExponentialMovingAverageRate exponentialMovingAverageRate = this;
        synchronized (exponentialMovingAverageRate) {
            copy = new ArrayList<Long>(this.times);
            count = this.count;
        }
        ExponentialMovingAverage rates = new ExponentialMovingAverage(this.window);
        double t0 = 0.0;
        double sum = 0.0;
        double weight = 0.0;
        double min = this.min;
        double max = this.max;
        int size = copy.size();
        for (Long time : copy) {
            double value;
            double t = (double)time.longValue() / this.factor;
            if (size == 1) {
                t0 = this.t0;
            } else if (t0 == 0.0) {
                t0 = t;
                continue;
            }
            double delta = t - t0;
            double d = value = delta > 0.0 ? delta / this.period : 0.0;
            if (value > max) {
                max = value;
            }
            if (value < min) {
                min = value;
            }
            double alpha = Math.exp(-delta * this.lapse);
            t0 = t;
            sum = alpha * sum + value;
            weight = alpha * weight + 1.0;
            rates.append(sum > 0.0 ? weight / sum : 0.0);
        }
        ExponentialMovingAverageRate exponentialMovingAverageRate2 = this;
        synchronized (exponentialMovingAverageRate2) {
            if (max > this.max) {
                this.max = max;
            }
            if (min < this.min) {
                this.min = min;
            }
        }
        return new Statistics(count, min < Double.MAX_VALUE ? min : 0.0, max, rates.getMean(), rates.getStandardDeviation());
    }

    public int getCount() {
        return (int)this.count;
    }

    public long getCountLong() {
        return this.count;
    }

    public double getTimeSinceLastMeasurement() {
        if (this.count == 0L) {
            return 0.0;
        }
        double t0 = this.lastTime();
        return (double)System.nanoTime() / this.factor - t0;
    }

    public double getMean() {
        long count = this.count;
        long l = count = count > (long)this.retention ? (long)this.retention : count;
        if (count == 0L) {
            return 0.0;
        }
        double t0 = this.lastTime();
        double t = (double)System.nanoTime() / this.factor;
        double value = t > t0 ? (t - t0) / this.period : 0.0;
        return (double)count / ((double)count / this.calc().getMean() + value);
    }

    private synchronized double lastTime() {
        if (this.times.size() > 0) {
            return (double)this.times.peekLast().longValue() / this.factor;
        }
        return this.t0;
    }

    public double getStandardDeviation() {
        return this.calc().getStandardDeviation();
    }

    public double getMax() {
        double min = this.calc().getMin();
        return min > 0.0 ? 1.0 / min : 0.0;
    }

    public double getMin() {
        double max = this.calc().getMax();
        return max > 0.0 ? 1.0 / max : 0.0;
    }

    public Statistics getStatistics() {
        return this.calc();
    }

    public String toString() {
        return String.format("[%s, timeSinceLast=%f]", this.getStatistics(), this.getTimeSinceLastMeasurement());
    }
}

