/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.mllp;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7AcknowledgementGenerator
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(Hl7AcknowledgementGenerator.class);
    String defaultNack = "MSH|^~\\&|||||||NACK||P|2.2\rMSA|AR|\r\n";

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        byte[] hl7Bytes = (byte[])message.getMandatoryBody(byte[].class);
        byte[] acknowledgementBytes = null;
        if (null == exchange.getException()) {
            acknowledgementBytes = this.generateApplicationAcceptAcknowledgementMessage(hl7Bytes);
            exchange.setProperty("CamelMllpAcknowledgementType", (Object)"AA");
        } else {
            acknowledgementBytes = this.generateApplicationErrorAcknowledgementMessage(hl7Bytes);
            exchange.setProperty("CamelMllpAcknowledgementType", (Object)"AE");
        }
        exchange.setProperty("CamelMllpAcknowledgement", (Object)acknowledgementBytes);
    }

    public byte[] generateApplicationAcceptAcknowledgementMessage(byte[] hl7MessageBytes) throws Hl7AcknowledgementGenerationException {
        return this.generateAcknowledgementMessage(hl7MessageBytes, "AA");
    }

    public byte[] generateApplicationRejectAcknowledgementMessage(byte[] hl7MessageBytes) throws Hl7AcknowledgementGenerationException {
        return this.generateAcknowledgementMessage(hl7MessageBytes, "AR");
    }

    public byte[] generateApplicationErrorAcknowledgementMessage(byte[] hl7MessageBytes) throws Hl7AcknowledgementGenerationException {
        return this.generateAcknowledgementMessage(hl7MessageBytes, "AE");
    }

    byte[] generateAcknowledgementMessage(byte[] hl7MessageBytes, String acknowledgementCode) throws Hl7AcknowledgementGenerationException {
        if (hl7MessageBytes == null) {
            throw new Hl7AcknowledgementGenerationException("Null HL7 message received for parsing operation");
        }
        byte fieldSeparator = hl7MessageBytes[3];
        byte componentSeparator = hl7MessageBytes[4];
        ArrayList<Integer> fieldSeparatorIndexes = new ArrayList<Integer>(10);
        int endOfMSH = -1;
        for (int i = 0; i < hl7MessageBytes.length; ++i) {
            if (fieldSeparator == hl7MessageBytes[i]) {
                fieldSeparatorIndexes.add(i);
                continue;
            }
            if (13 != hl7MessageBytes[i]) continue;
            endOfMSH = i;
            break;
        }
        if (-1 == endOfMSH) {
            throw new Hl7AcknowledgementGenerationException("Failed to find the end of the  MSH Segment while attempting to generate response", hl7MessageBytes);
        }
        if (8 > fieldSeparatorIndexes.size()) {
            throw new Hl7AcknowledgementGenerationException("Insufficient number of fields in after MSH-2 in MSH to generate a response - 8 are required but " + fieldSeparatorIndexes.size() + " " + "were found", hl7MessageBytes);
        }
        ByteArrayOutputStream acknowledgement = new ByteArrayOutputStream(1024);
        acknowledgement.write(hl7MessageBytes, 0, (Integer)fieldSeparatorIndexes.get(1));
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(3), (Integer)fieldSeparatorIndexes.get(4) - (Integer)fieldSeparatorIndexes.get(3));
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(4), (Integer)fieldSeparatorIndexes.get(5) - (Integer)fieldSeparatorIndexes.get(4));
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(1), (Integer)fieldSeparatorIndexes.get(2) - (Integer)fieldSeparatorIndexes.get(1));
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(2), (Integer)fieldSeparatorIndexes.get(3) - (Integer)fieldSeparatorIndexes.get(2));
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(5), (Integer)fieldSeparatorIndexes.get(7) - (Integer)fieldSeparatorIndexes.get(5));
        acknowledgement.write(fieldSeparator);
        acknowledgement.write("ACK".getBytes(), 0, 3);
        int msh92start = -1;
        for (int j = (Integer)fieldSeparatorIndexes.get(7) + 1; j < (Integer)fieldSeparatorIndexes.get(8); ++j) {
            if (componentSeparator != hl7MessageBytes[j]) continue;
            msh92start = j;
            break;
        }
        if (-1 == msh92start) {
            LOG.warn("Didn't find component separator for MSH-9.2 - sending ACK in MSH-9");
        } else {
            acknowledgement.write(hl7MessageBytes, msh92start, (Integer)fieldSeparatorIndexes.get(8) - msh92start);
        }
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(8), endOfMSH - (Integer)fieldSeparatorIndexes.get(8));
        acknowledgement.write(13);
        acknowledgement.write("MSA".getBytes(), 0, 3);
        acknowledgement.write(fieldSeparator);
        acknowledgement.write(acknowledgementCode.getBytes(), 0, 2);
        acknowledgement.write(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(8), (Integer)fieldSeparatorIndexes.get(9) - (Integer)fieldSeparatorIndexes.get(8));
        acknowledgement.write(13);
        acknowledgement.write(13);
        acknowledgement.write(10);
        return acknowledgement.toByteArray();
    }
}

