/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.qpid.jms.JmsAcknowledgeCallback;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsMessageAvailableConsumer;
import org.apache.qpid.jms.JmsMessageAvailableListener;
import org.apache.qpid.jms.JmsMessageDispatcher;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.JmsTransactionContext;
import org.apache.qpid.jms.JmsTransactionSynchronization;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.util.FifoMessageQueue;
import org.apache.qpid.jms.util.MessageQueue;
import org.apache.qpid.jms.util.PriorityMessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageConsumer
implements AutoCloseable,
MessageConsumer,
JmsMessageAvailableConsumer,
JmsMessageDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(JmsMessageConsumer.class);
    protected final JmsSession session;
    protected final JmsConnection connection;
    protected JmsConsumerInfo consumerInfo;
    protected final int acknowledgementMode;
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected boolean started;
    protected MessageListener messageListener;
    protected JmsMessageAvailableListener availableListener;
    protected final MessageQueue messageQueue;
    protected final Lock lock = new ReentrantLock();
    protected final AtomicBoolean suspendedConnection = new AtomicBoolean();
    protected final AtomicReference<Exception> failureCause = new AtomicReference();

    protected JmsMessageConsumer(JmsConsumerId consumerId, JmsSession session, JmsDestination destination, String selector, boolean noLocal) throws JMSException {
        this(consumerId, session, destination, null, selector, noLocal);
    }

    protected JmsMessageConsumer(JmsConsumerId consumerId, JmsSession session, JmsDestination destination, String name, String selector, boolean noLocal) throws JMSException {
        this.session = session;
        this.connection = session.getConnection();
        this.acknowledgementMode = session.acknowledgementMode();
        if (destination.isTemporary()) {
            this.connection.checkConsumeFromTemporaryDestination((JmsTemporaryDestination)destination);
        }
        this.messageQueue = this.connection.isLocalMessagePriority() ? new PriorityMessageQueue() : new FifoMessageQueue();
        JmsPrefetchPolicy prefetchPolicy = session.getPrefetchPolicy();
        JmsRedeliveryPolicy redeliveryPolicy = session.getRedeliveryPolicy().copy();
        JmsDeserializationPolicy deserializationPolicy = session.getDeserializationPolicy().copy();
        this.consumerInfo = new JmsConsumerInfo(consumerId);
        this.consumerInfo.setClientId(this.connection.getClientID());
        this.consumerInfo.setSelector(selector);
        this.consumerInfo.setSubscriptionName(name);
        this.consumerInfo.setDestination(destination);
        this.consumerInfo.setAcknowledgementMode(this.acknowledgementMode);
        this.consumerInfo.setNoLocal(noLocal);
        this.consumerInfo.setBrowser(this.isBrowser());
        this.consumerInfo.setPrefetchSize(prefetchPolicy.getConfiguredPrefetch(session, destination, this.isDurableSubscription(), this.isBrowser()));
        this.consumerInfo.setRedeliveryPolicy(redeliveryPolicy);
        this.consumerInfo.setLocalMessageExpiry(this.connection.isLocalMessageExpiry());
        this.consumerInfo.setPresettle(session.getPresettlePolicy().isConsumerPresttled(session, destination));
        this.consumerInfo.setDeserializationPolicy(deserializationPolicy);
        session.add(this);
        try {
            session.getConnection().createResource(this.consumerInfo);
        }
        catch (JMSException jmse) {
            session.remove(this);
            throw jmse;
        }
    }

    public void init() throws JMSException {
        this.startConsumerResource();
    }

    private void startConsumerResource() throws JMSException {
        try {
            this.session.getConnection().startResource(this.consumerInfo);
        }
        catch (JMSException ex) {
            this.session.remove(this);
            throw ex;
        }
    }

    @Override
    public void close() throws JMSException {
        if (!this.closed.get()) {
            this.session.getTransactionContext().addSynchronization(new JmsTransactionSynchronization(){

                @Override
                public boolean validate(JmsTransactionContext context) throws Exception {
                    if (JmsMessageConsumer.this.isBrowser() || !context.isActiveInThisContext(JmsMessageConsumer.this.getConsumerId())) {
                        JmsMessageConsumer.this.doClose();
                        return false;
                    }
                    return true;
                }

                @Override
                public void afterCommit() throws Exception {
                    JmsMessageConsumer.this.doClose();
                }

                @Override
                public void afterRollback() throws Exception {
                    JmsMessageConsumer.this.doClose();
                }
            });
        }
    }

    protected void doClose() throws JMSException {
        this.shutdown();
        this.connection.destroyResource(this.consumerInfo);
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    protected void shutdown(Exception cause) throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.setFailureCause(cause);
            this.session.remove(this);
            this.stop(true);
        }
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        this.checkMessageListener();
        if (timeout == 0L) {
            timeout = -1L;
        }
        return this.copy(this.ackFromReceive(this.dequeue(timeout, this.connection.isReceiveLocalOnly())));
    }

    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        this.checkMessageListener();
        return this.copy(this.ackFromReceive(this.dequeue(0L, this.connection.isReceiveNoWaitLocalOnly())));
    }

    private JmsInboundMessageDispatch dequeue(long timeout, boolean localCheckOnly) throws JMSException {
        boolean pullConsumer;
        boolean pullForced = pullConsumer = this.isPullConsumer();
        try {
            JmsInboundMessageDispatch envelope;
            long deadline = 0L;
            if (timeout > 0L) {
                deadline = System.currentTimeMillis() + timeout;
            }
            this.performPullIfRequired(timeout, false);
            while (true) {
                envelope = null;
                envelope = pullForced || pullConsumer ? this.messageQueue.dequeue(0L) : this.messageQueue.dequeue(timeout);
                if (this.getFailureCause() != null) {
                    LOG.debug("{} receive failed: {}", (Object)this.getConsumerId(), (Object)this.getFailureCause().getMessage());
                    throw JmsExceptionSupport.create(this.getFailureCause());
                }
                if (envelope == null) {
                    if (timeout == 0L && (pullForced || localCheckOnly) || pullConsumer || this.messageQueue.isClosed()) {
                        return null;
                    }
                    if (timeout > 0L) {
                        timeout = Math.max(deadline - System.currentTimeMillis(), 0L);
                    }
                    if (timeout < 0L || localCheckOnly) continue;
                    pullForced = true;
                    if (!this.performPullIfRequired(timeout, true)) continue;
                    this.startConsumerResource();
                    continue;
                }
                if (this.consumeExpiredMessage(envelope)) {
                    LOG.trace("{} filtered expired message: {}", (Object)this.getConsumerId(), (Object)envelope);
                    this.doAckExpired(envelope);
                    if (timeout > 0L) {
                        timeout = Math.max(deadline - System.currentTimeMillis(), 0L);
                    }
                    this.performPullIfRequired(timeout, false);
                    continue;
                }
                if (!this.redeliveryExceeded(envelope)) break;
                LOG.debug("{} filtered message with excessive redelivery count: {}", (Object)this.getConsumerId(), (Object)envelope);
                this.doAckUndeliverable(envelope);
                if (timeout > 0L) {
                    timeout = Math.max(deadline - System.currentTimeMillis(), 0L);
                }
                this.performPullIfRequired(timeout, false);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.getConsumerId() + " received message: " + envelope);
            }
            return envelope;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JmsExceptionSupport.create(e);
        }
    }

    private boolean consumeExpiredMessage(JmsInboundMessageDispatch dispatch) {
        return !this.isBrowser() && this.consumerInfo.isLocalMessageExpiry() && dispatch.getMessage().isExpired();
    }

    protected boolean redeliveryExceeded(JmsInboundMessageDispatch envelope) {
        LOG.trace("checking envelope with {} redeliveries", (Object)envelope.getRedeliveryCount());
        JmsRedeliveryPolicy redeliveryPolicy = this.consumerInfo.getRedeliveryPolicy();
        return redeliveryPolicy != null && redeliveryPolicy.getMaxRedeliveries(this.getDestination()) >= 0 && redeliveryPolicy.getMaxRedeliveries(this.getDestination()) < envelope.getRedeliveryCount();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            IllegalStateException jmsEx = null;
            if (this.getFailureCause() == null) {
                jmsEx = new IllegalStateException("The MessageConsumer is closed");
            } else {
                jmsEx = new IllegalStateException("The MessageConsumer was closed due to an unrecoverable error.");
                jmsEx.initCause((Throwable)this.getFailureCause());
            }
            throw jmsEx;
        }
    }

    void setFailureCause(Exception failureCause) {
        this.failureCause.set(failureCause);
    }

    Exception getFailureCause() {
        if (this.failureCause.get() == null) {
            return this.session.getFailureCause();
        }
        return this.failureCause.get();
    }

    JmsMessage copy(JmsInboundMessageDispatch envelope) throws JMSException {
        if (envelope == null || envelope.getMessage() == null) {
            return null;
        }
        return envelope.getMessage().copy();
    }

    JmsInboundMessageDispatch ackFromReceive(JmsInboundMessageDispatch envelope) throws JMSException {
        if (envelope != null && envelope.getMessage() != null) {
            JmsMessage message = envelope.getMessage();
            if (message.getAcknowledgeCallback() != null) {
                this.doAckDelivered(envelope);
            } else {
                this.doAckConsumed(envelope);
            }
        }
        return envelope;
    }

    private JmsInboundMessageDispatch doAckConsumed(JmsInboundMessageDispatch envelope) throws JMSException {
        this.checkClosed();
        try {
            this.session.acknowledge(envelope, ProviderConstants.ACK_TYPE.ACCEPTED);
        }
        catch (JMSException ex) {
            this.session.onException(ex);
            throw ex;
        }
        return envelope;
    }

    private JmsInboundMessageDispatch doAckDelivered(JmsInboundMessageDispatch envelope) throws JMSException {
        try {
            this.session.acknowledge(envelope, ProviderConstants.ACK_TYPE.DELIVERED);
        }
        catch (JMSException ex) {
            this.session.onException(ex);
            throw ex;
        }
        return envelope;
    }

    private void doAckExpired(JmsInboundMessageDispatch envelope) throws JMSException {
        try {
            this.session.acknowledge(envelope, ProviderConstants.ACK_TYPE.EXPIRED);
        }
        catch (JMSException ex) {
            this.session.onException(ex);
            throw ex;
        }
    }

    private void doAckUndeliverable(JmsInboundMessageDispatch envelope) throws JMSException {
        try {
            this.session.acknowledge(envelope, ProviderConstants.ACK_TYPE.MODIFIED_FAILED_UNDELIVERABLE);
        }
        catch (JMSException ex) {
            this.session.onException(ex);
            throw ex;
        }
    }

    private void doAckReleased(JmsInboundMessageDispatch envelope) throws JMSException {
        try {
            this.session.acknowledge(envelope, ProviderConstants.ACK_TYPE.RELEASED);
        }
        catch (JMSException ex) {
            this.session.onException(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        this.lock.lock();
        try {
            if (this.acknowledgementMode == 2) {
                envelope.getMessage().setAcknowledgeCallback(new JmsAcknowledgeCallback(this.session));
            }
            if (envelope.isEnqueueFirst()) {
                this.messageQueue.enqueueFirst(envelope);
            } else {
                this.messageQueue.enqueue(envelope);
            }
            if (this.messageListener != null && this.started) {
                this.session.getExecutor().execute(new MessageDeliverTask());
            } else if (this.availableListener != null) {
                this.session.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (JmsMessageConsumer.this.session.isStarted()) {
                            JmsMessageConsumer.this.availableListener.onMessageAvailable(JmsMessageConsumer.this);
                        }
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            this.started = true;
            this.messageQueue.start();
            this.drainMessageQueueToListener();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean closeMessageQueue) {
        this.lock.lock();
        try {
            this.started = false;
            if (closeMessageQueue) {
                this.messageQueue.close();
            } else {
                this.messageQueue.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void suspendForRollback() throws JMSException {
        this.stop();
        this.session.getConnection().stopResource(this.consumerInfo);
    }

    void resumeAfterRollback() throws JMSException {
        if (!this.messageQueue.isEmpty()) {
            List<JmsInboundMessageDispatch> drain = this.messageQueue.removeAll();
            for (JmsInboundMessageDispatch envelope : drain) {
                this.doAckReleased(envelope);
            }
            drain.clear();
        }
        this.start();
        this.startConsumerResource();
    }

    void drainMessageQueueToListener() {
        if (this.messageListener != null && this.started) {
            this.session.getExecutor().execute(new MessageDeliverTask());
        }
    }

    public JmsConsumerId getConsumerId() {
        return this.consumerInfo.getId();
    }

    public JmsDestination getDestination() {
        return this.consumerInfo.getDestination();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        if (this.consumerInfo.getPrefetchSize() == 0) {
            throw new JMSException("Illegal prefetch size of zero. This setting is not supportedfor asynchronous consumers please set a value of at least 1");
        }
        this.messageListener = listener;
        this.drainMessageQueueToListener();
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.consumerInfo.getSelector();
    }

    public int getPrefetchSize() {
        return this.consumerInfo.getPrefetchSize();
    }

    protected void checkMessageListener() throws JMSException {
        this.session.checkMessageListener();
    }

    boolean hasMessageListener() {
        return this.messageListener != null;
    }

    boolean isUsingDestination(JmsDestination destination) {
        return this.consumerInfo.getDestination().equals(destination);
    }

    protected int getMessageQueueSize() {
        return this.messageQueue.size();
    }

    protected boolean isNoLocal() {
        return this.consumerInfo.isNoLocal();
    }

    public boolean isDurableSubscription() {
        return false;
    }

    public boolean isBrowser() {
        return false;
    }

    public boolean isPullConsumer() {
        return this.getPrefetchSize() == 0;
    }

    @Override
    public void setAvailableListener(JmsMessageAvailableListener availableListener) {
        this.availableListener = availableListener;
    }

    @Override
    public JmsMessageAvailableListener getAvailableListener() {
        return this.availableListener;
    }

    protected void onConnectionInterrupted() {
        this.messageQueue.clear();
    }

    protected void onConnectionRecovery(Provider provider) throws Exception {
        ProviderFuture request = new ProviderFuture();
        provider.create(this.consumerInfo, request);
        request.sync();
    }

    protected void onConnectionRecovered(Provider provider) throws Exception {
        ProviderFuture request = new ProviderFuture();
        provider.start(this.consumerInfo, request);
        request.sync();
    }

    protected void onConnectionRestored() {
    }

    protected boolean performPullIfRequired(long timeout, boolean treatAsPullConsumer) throws JMSException {
        if ((this.isPullConsumer() || treatAsPullConsumer) && this.messageQueue.isRunning() && this.messageQueue.isEmpty()) {
            this.connection.pull(this.getConsumerId(), timeout);
            return true;
        }
        return false;
    }

    private final class MessageDeliverTask
    implements Runnable {
        private MessageDeliverTask() {
        }

        @Override
        public void run() {
            JmsInboundMessageDispatch envelope;
            while (JmsMessageConsumer.this.session.isStarted() && (envelope = JmsMessageConsumer.this.messageQueue.dequeueNoWait()) != null) {
                try {
                    JmsMessage copy = null;
                    if (JmsMessageConsumer.this.consumeExpiredMessage(envelope)) {
                        LOG.trace("{} filtered expired message: {}", (Object)JmsMessageConsumer.this.getConsumerId(), (Object)envelope);
                        JmsMessageConsumer.this.doAckExpired(envelope);
                        continue;
                    }
                    if (JmsMessageConsumer.this.redeliveryExceeded(envelope)) {
                        LOG.trace("{} filtered message with excessive redelivery count: {}", (Object)JmsMessageConsumer.this.getConsumerId(), (Object)envelope);
                        JmsMessageConsumer.this.doAckUndeliverable(envelope);
                        continue;
                    }
                    boolean deliveryFailed = false;
                    boolean autoAckOrDupsOk = JmsMessageConsumer.this.acknowledgementMode == 1 || JmsMessageConsumer.this.acknowledgementMode == 3;
                    copy = autoAckOrDupsOk ? JmsMessageConsumer.this.copy(JmsMessageConsumer.this.doAckDelivered(envelope)) : JmsMessageConsumer.this.copy(JmsMessageConsumer.this.ackFromReceive(envelope));
                    JmsMessageConsumer.this.session.clearSessionRecovered();
                    try {
                        JmsMessageConsumer.this.messageListener.onMessage((Message)copy);
                    }
                    catch (RuntimeException rte) {
                        deliveryFailed = true;
                    }
                    if (!autoAckOrDupsOk || JmsMessageConsumer.this.session.isSessionRecovered()) continue;
                    if (!deliveryFailed) {
                        JmsMessageConsumer.this.doAckConsumed(envelope);
                        continue;
                    }
                    JmsMessageConsumer.this.doAckReleased(envelope);
                }
                catch (Exception e) {
                    JmsMessageConsumer.this.session.getConnection().onException(e);
                }
            }
        }
    }
}

