/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionCoordinator;
import org.apache.qpid.jms.provider.amqp.builders.AmqpTransactionCoordinatorBuilder;
import org.apache.qpid.proton.amqp.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionContext
implements AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransactionContext.class);
    private final AmqpSession session;
    private final Set<AmqpConsumer> txConsumers = new LinkedHashSet<AmqpConsumer>();
    private JmsTransactionId current;
    private AmqpTransactionCoordinator coordinator;

    public AmqpTransactionContext(AmqpSession session, JmsSessionInfo resourceInfo) {
        this.session = session;
    }

    public void begin(final JmsTransactionId txId, final AsyncResult request) throws Exception {
        if (this.current != null) {
            throw new IOException("Begin called while a TX is still Active.");
        }
        final AsyncResult declareCompletion = new AsyncResult(){

            @Override
            public void onSuccess() {
                AmqpTransactionContext.this.current = txId;
                request.onSuccess();
            }

            @Override
            public void onFailure(Throwable result) {
                AmqpTransactionContext.this.current = null;
                request.onFailure(result);
            }

            @Override
            public boolean isComplete() {
                return AmqpTransactionContext.this.current != null;
            }
        };
        if (this.coordinator == null || this.coordinator.isClosed()) {
            AmqpTransactionCoordinatorBuilder builder = new AmqpTransactionCoordinatorBuilder(this, (JmsSessionInfo)this.session.getResourceInfo());
            builder.buildResource(new AsyncResult(){

                @Override
                public void onSuccess() {
                    try {
                        AmqpTransactionContext.this.coordinator.declare(txId, declareCompletion);
                    }
                    catch (Exception e) {
                        request.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable result) {
                    request.onFailure(result);
                }

                @Override
                public boolean isComplete() {
                    return request.isComplete();
                }
            });
        } else {
            this.coordinator.declare(txId, declareCompletion);
        }
    }

    public void commit(JmsTransactionInfo transactionInfo, final AsyncResult request) throws Exception {
        if (!transactionInfo.getId().equals(this.current)) {
            if (!transactionInfo.isInDoubt() && this.current == null) {
                throw new IllegalStateException("Commit called with no active Transaction.");
            }
            if (!transactionInfo.isInDoubt() && this.current != null) {
                throw new IllegalStateException("Attempt to Commit a transaction other than the current one");
            }
            throw new TransactionRolledBackException("Transaction in doubt and cannot be committed.");
        }
        this.preCommit();
        LOG.trace("TX Context[{}] committing current TX[[]]", (Object)this, (Object)this.current);
        this.coordinator.discharge(this.current, new AsyncResult(){

            @Override
            public void onSuccess() {
                AmqpTransactionContext.this.current = null;
                AmqpTransactionContext.this.postCommit();
                request.onSuccess();
            }

            @Override
            public void onFailure(Throwable result) {
                AmqpTransactionContext.this.current = null;
                AmqpTransactionContext.this.postCommit();
                request.onFailure(result);
            }

            @Override
            public boolean isComplete() {
                return AmqpTransactionContext.this.current == null;
            }
        }, true);
    }

    public void rollback(JmsTransactionInfo transactionInfo, final AsyncResult request) throws Exception {
        if (!transactionInfo.getId().equals(this.current)) {
            if (!transactionInfo.isInDoubt() && this.current == null) {
                throw new IllegalStateException("Rollback called with no active Transaction.");
            }
            if (!transactionInfo.isInDoubt() && this.current != null) {
                throw new IllegalStateException("Attempt to rollback a transaction other than the current one");
            }
            request.onSuccess();
            return;
        }
        this.preRollback();
        LOG.trace("TX Context[{}] rolling back current TX[[]]", (Object)this, (Object)this.current);
        this.coordinator.discharge(this.current, new AsyncResult(){

            @Override
            public void onSuccess() {
                AmqpTransactionContext.this.current = null;
                AmqpTransactionContext.this.postRollback();
                request.onSuccess();
            }

            @Override
            public void onFailure(Throwable result) {
                AmqpTransactionContext.this.current = null;
                AmqpTransactionContext.this.postRollback();
                request.onFailure(result);
            }

            @Override
            public boolean isComplete() {
                return AmqpTransactionContext.this.current == null;
            }
        }, false);
    }

    public void registerTxConsumer(AmqpConsumer consumer) {
        this.txConsumers.add(consumer);
    }

    public AmqpSession getSession() {
        return this.session;
    }

    public JmsTransactionId getTransactionId() {
        return this.current;
    }

    public boolean isTransactionFailed() {
        return this.coordinator == null ? false : this.coordinator.isClosed();
    }

    public Binary getAmqpTransactionId() {
        Binary result = null;
        if (this.current != null) {
            result = (Binary)this.current.getProviderHint();
        }
        return result;
    }

    public String toString() {
        return this.session.getSessionId() + ": txContext";
    }

    private void preCommit() {
        for (AmqpConsumer consumer : this.txConsumers) {
            consumer.preCommit();
        }
    }

    private void preRollback() {
        for (AmqpConsumer consumer : this.txConsumers) {
            consumer.preRollback();
        }
    }

    private void postCommit() {
        for (AmqpConsumer consumer : this.txConsumers) {
            consumer.postCommit();
        }
        this.txConsumers.clear();
    }

    private void postRollback() {
        for (AmqpConsumer consumer : this.txConsumers) {
            consumer.postRollback();
        }
        this.txConsumers.clear();
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpTransactionCoordinator) {
            this.coordinator = (AmqpTransactionCoordinator)resource;
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
    }

    @Override
    public AmqpProvider getProvider() {
        return this.session.getProvider();
    }
}

