/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonLinkEntityProducer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonLinksEntityProducer {
    private final EntityProviderWriteProperties properties;

    public JsonLinksEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            if (!this.properties.isOmitJsonWrapper()) {
                jsonStreamWriter.beginObject().name("d");
            }
            if (this.properties.getInlineCountType() == InlineCount.ALLPAGES) {
                int inlineCount = this.properties.getInlineCount() == null ? 0 : this.properties.getInlineCount();
                jsonStreamWriter.beginObject().namedStringValueRaw("__count", String.valueOf(inlineCount)).separator().name("results");
            }
            jsonStreamWriter.beginArray();
            String serviceRoot = this.properties.getServiceRoot().toASCIIString();
            boolean first = true;
            for (Map<String, Object> entryData : data) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                JsonLinkEntityProducer.appendUri(jsonStreamWriter, (serviceRoot == null ? "" : serviceRoot) + AtomEntryEntityProducer.createSelfLink(entityInfo, entryData, null));
            }
            jsonStreamWriter.endArray();
            if (this.properties.getInlineCountType() == InlineCount.ALLPAGES) {
                jsonStreamWriter.endObject();
            }
            if (!this.properties.isOmitJsonWrapper()) {
                jsonStreamWriter.endObject();
            }
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }
}

