/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheManager;

public final class JCacheHelper {
    private JCacheHelper() {
    }

    public static <K, V> JCacheManager<K, V> createManager(JCacheConfiguration configuration) {
        if (JCacheHelper.isOSGi()) {
            try {
                Class<?> type = Class.forName("org.apache.camel.component.jcache.osgi.OSGiCacheManager");
                Constructor<?> ctor = type.getConstructor(JCacheConfiguration.class);
                return (JCacheManager)ctor.newInstance(configuration);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return new JCacheManager(configuration);
    }

    public static <T> T tcclProxy(T instance, Class<T> type, ClassLoader classLoader) {
        return (T)Proxy.newProxyInstance(JCacheHelper.class.getClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                Object object2 = method.invoke(instance, args);
                return object2;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        });
    }

    public static boolean isOSGi() {
        try {
            Method method;
            Class<?> fu = Class.forName("org.osgi.framework.FrameworkUtil");
            if (fu != null && (method = fu.getMethod("getBundle", Class.class)) != null) {
                return method.invoke(null, JCacheHelper.class) != null;
            }
        }
        catch (ClassNotFoundException fu) {
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        return false;
    }
}

