/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class RestComponent
extends UriEndpointComponent {
    private String componentName;
    private String apiDoc;
    private String host;

    public RestComponent() {
        super(RestEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String uriTemplate;
        String path;
        String restConfigurationName = this.getAndRemoveParameter(parameters, "componentName", String.class, this.componentName);
        RestEndpoint answer = new RestEndpoint(uri, this);
        answer.setComponentName(restConfigurationName);
        answer.setApiDoc(this.apiDoc);
        RestConfiguration config = this.getCamelContext().getRestConfiguration(restConfigurationName, true);
        String h = this.resolveAndRemoveReferenceParameter(parameters, "host", String.class, this.host);
        if (h == null && config != null) {
            h = config.getHost();
            int port = config.getPort();
            if (port > 0 && port != 80 && port != 443) {
                h = h + ":" + port;
            }
        }
        if (h != null && !h.startsWith("http://") && !h.startsWith("https://")) {
            h = "http://" + h;
        }
        answer.setHost(h);
        String query = ObjectHelper.after(uri, "?");
        if (query != null) {
            answer.setQueryParameters(query);
        }
        this.setProperties(answer, parameters);
        answer.setParameters(parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be rest:method:path[:uriTemplate] where uriTemplate is optional");
        }
        String method = ObjectHelper.before(remaining, ":");
        String s = ObjectHelper.after(remaining, ":");
        if (s != null && s.contains(":")) {
            path = ObjectHelper.before(s, ":");
            uriTemplate = ObjectHelper.after(s, ":");
        } else {
            path = s;
            uriTemplate = null;
        }
        path = FileUtil.stripTrailingSeparator(path);
        uriTemplate = FileUtil.stripTrailingSeparator(uriTemplate);
        answer.setMethod(method);
        answer.setPath(path);
        answer.setUriTemplate(uriTemplate);
        if (answer.getComponentName() == null && config != null) {
            String name = config.getProducerComponent();
            if (name == null) {
                name = config.getComponent();
            }
            answer.setComponentName(name);
        }
        if (answer.getApiDoc() == null && config != null) {
            answer.setApiDoc(config.getProducerApiDoc());
        }
        return answer;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getApiDoc() {
        return this.apiDoc;
    }

    public void setApiDoc(String apiDoc) {
        this.apiDoc = apiDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

