/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private Configuration config;
    private HashMap<SymbolicName, XQueryFunction> functions = new HashMap(20);

    public XQueryFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        SymbolicName keyObj = function.getIdentificationKey();
        XQueryFunction existing = this.functions.get(keyObj);
        if (existing == function) {
            return;
        }
        if (existing != null) {
            XPathException err = new XPathException("Duplicate definition of function " + function.getDisplayName() + " (see line " + existing.getLineNumber() + " in " + existing.getSystemId() + ')');
            err.setErrorCode("XQST0034");
            err.setIsStaticError(true);
            err.setLocator(function);
            throw err;
        }
        this.functions.put(keyObj, function);
    }

    @Override
    public boolean isAvailable(SymbolicName functionName) {
        return this.functions.get(functionName) != null;
    }

    @Override
    public Expression bind(SymbolicName functionName, Expression[] arguments, StaticContext env) throws XPathException {
        XQueryFunction fd = this.functions.get(functionName);
        if (fd != null) {
            if (fd.isPrivate() && fd.getStaticContext() != env) {
                throw new XPathException("Cannot call the private function " + functionName.getComponentName().getDisplayName() + " from outside its module", "XPST0017");
            }
            UserFunctionCall ufc = new UserFunctionCall();
            ufc.setFunctionName(fd.getFunctionName());
            ufc.setArguments(arguments);
            ufc.setStaticType(fd.getResultType());
            UserFunction fn = fd.getUserFunction();
            if (fn == null) {
                fd.registerReference(ufc);
            } else {
                ufc.setFunction(fn);
            }
            return ufc;
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, int staticArgs) {
        SymbolicName functionKey = XQueryFunction.getIdentificationKey(functionName, staticArgs);
        return this.functions.get(functionKey);
    }

    public XQueryFunction getDeclarationByKey(SymbolicName functionKey) {
        return this.functions.get(functionKey);
    }

    public Iterator<XQueryFunction> getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions(QueryModule env) throws XPathException {
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        for (XQueryFunction fn : this.functions.values()) {
            fn.compile();
        }
        for (XQueryFunction fn : this.functions.values()) {
            fn.checkReferences(visitor);
        }
    }

    protected void optimizeGlobalFunctions() throws XPathException {
        for (XQueryFunction fn : this.functions.values()) {
            fn.optimize();
        }
    }

    public void explainGlobalFunctions(ExpressionPresenter out) throws XPathException {
        for (XQueryFunction fn : this.functions.values()) {
            fn.explain(out);
        }
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        SymbolicName functionKey = new SymbolicName(158, new StructuredQName("", uri, localName), arity);
        XQueryFunction fd = this.functions.get(functionKey);
        if (fd == null) {
            return null;
        }
        return fd.getUserFunction();
    }

    @Override
    public FunctionLibrary copy() {
        XQueryFunctionLibrary qfl = new XQueryFunctionLibrary(this.config);
        qfl.functions = new HashMap<SymbolicName, XQueryFunction>(this.functions);
        return qfl;
    }

    public static class UnresolvedCallable
    implements UserFunctionResolvable,
    Callable {
        SymbolicName symbolicName;
        UserFunction function;

        public UnresolvedCallable(SymbolicName symbolicName) {
            this.symbolicName = symbolicName;
        }

        public StructuredQName getFunctionName() {
            return this.symbolicName.getComponentName();
        }

        public int getArity() {
            return this.symbolicName.getArity();
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            if (this.function == null) {
                throw new XPathException("Forwards reference to XQuery function has not been resolved");
            }
            Sequence[] args = new Sequence[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                args[i] = SequenceExtent.makeSequenceExtent(arguments[i].iterate());
            }
            return this.function.call(context.newCleanContext(), args);
        }

        public void setFunction(UserFunction function) {
            this.function = function;
        }

        public UserFunction getFunction() {
            return this.function;
        }
    }
}

