/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.stored.SqlStoredEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlStoredComponent
extends UriEndpointComponent {
    private DataSource dataSource;

    public SqlStoredComponent() {
        super(SqlStoredEndpoint.class);
    }

    public SqlStoredComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    public SqlStoredComponent(CamelContext context) {
        super(context, SqlStoredEndpoint.class);
    }

    public SqlStoredComponent(CamelContext context, Class<? extends Endpoint> endpointClass) {
        super(context, endpointClass);
    }

    protected Endpoint createEndpoint(String uri, String template, Map<String, Object> parameters) throws Exception {
        DataSource target = null;
        DataSource ds = (DataSource)this.resolveAndRemoveReferenceParameter(parameters, "dataSource", DataSource.class);
        if (ds != null) {
            target = ds;
        }
        if (target == null) {
            target = this.dataSource;
        }
        if (target == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(target);
        SqlStoredEndpoint endpoint = new SqlStoredEndpoint(uri, this, jdbcTemplate);
        endpoint.setTemplate(template);
        return endpoint;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

