/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

public class ImmediateComponentManager
extends AbstractComponentManager
implements ServiceFactory {
    private volatile Object m_implementationObject;
    private volatile int m_useCount;
    private ComponentContextImpl m_componentContext;
    private ComponentHolder m_componentHolder;
    private Dictionary m_factoryProperties;
    private Dictionary m_properties;
    private Dictionary m_serviceProperties;
    private Dictionary m_configurationProperties;

    public ImmediateComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
        super(activator, metadata, componentMethods);
        this.m_componentHolder = componentHolder;
    }

    void clear() {
        if (this.m_componentHolder != null) {
            this.m_componentHolder.disposed(this);
        }
        super.clear();
    }

    protected boolean createComponent() {
        if (!this.isWriteLocked()) {
            throw new IllegalStateException("need write lock (createComponent)");
        }
        if (this.m_implementationObject == null) {
            final ComponentContextImpl tmpContext = new ComponentContextImpl(this);
            Object tmpComponent = this.createImplementationObject(tmpContext, new SetImplementationObject(){

                public void setImplementationObject(Object implementationObject) {
                    ImmediateComponentManager.this.m_componentContext = tmpContext;
                    ImmediateComponentManager.this.m_implementationObject = implementationObject;
                }
            });
            if (tmpComponent == null) {
                return false;
            }
            this.log(4, "Set implementation object for component {0}", new Object[]{this.getName()}, null);
            this.getActivator().missingServicePresent(this.getServiceReference());
        }
        return true;
    }

    protected void deleteComponent(int reason) {
        if (!this.isWriteLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        if (this.m_implementationObject != null) {
            this.disposeImplementationObject(this.m_implementationObject, this.m_componentContext, reason);
            this.m_useCount = 0;
            this.m_implementationObject = null;
            this.log(4, "Unset implementation object for component {0} in deleteComponent for reason {1}", new Object[]{this.getName(), reason}, null);
            this.m_componentContext = null;
            this.m_properties = null;
            this.m_serviceProperties = null;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.m_componentContext;
    }

    Object getInstance() {
        return this.m_implementationObject;
    }

    protected Object createImplementationObject(ComponentContext componentContext, SetImplementationObject setter) {
        Object implementationObject;
        try {
            Class implementationObjectClass = this.getActivator().getBundleContext().getBundle().loadClass(this.getComponentMetadata().getImplementationClassName());
            implementationObject = implementationObjectClass.newInstance();
        }
        catch (Throwable t) {
            this.log(1, "Error during instantiation of the implementation object", t);
            return null;
        }
        Map parameters = this.getParameterMap();
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            Map params;
            DependencyManager dm = (DependencyManager)it.next();
            if (dm.open(implementationObject, params = (Map)parameters.get(dm))) continue;
            this.log(1, "Cannot create component instance due to failure to bind reference {0}", new Object[]{dm.getName()}, null);
            it = this.getReversedDependencyManagers();
            while (it.hasNext()) {
                dm = (DependencyManager)it.next();
                dm.close(implementationObject);
            }
            return null;
        }
        MethodResult result = this.getComponentMethods().getActivateMethod().invoke(implementationObject, new ActivateMethod.ActivatorParameter(componentContext, 1), null);
        if (result == null) {
            it = this.getDependencyManagers();
            while (it.hasNext()) {
                DependencyManager dm = (DependencyManager)it.next();
                dm.close(implementationObject);
            }
            return null;
        }
        setter.setImplementationObject(implementationObject);
        this.setServiceProperties(result);
        return implementationObject;
    }

    protected void disposeImplementationObject(Object implementationObject, ComponentContext componentContext, int reason) {
        MethodResult result = this.getComponentMethods().getDeactivateMethod().invoke(implementationObject, new ActivateMethod.ActivatorParameter(componentContext, reason), null);
        if (result != null) {
            this.setServiceProperties(result);
        }
        Iterator it = this.getReversedDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.close(implementationObject);
        }
    }

    AbstractComponentManager.State getSatisfiedState() {
        return AbstractComponentManager.Registered.getInstance();
    }

    AbstractComponentManager.State getActiveState() {
        return AbstractComponentManager.Active.getInstance();
    }

    void update(DependencyManager dependencyManager, ServiceReference ref) {
        dependencyManager.update(this.m_implementationObject, ref);
    }

    void invokeBindMethod(DependencyManager dependencyManager, ServiceReference reference) {
        dependencyManager.invokeBindMethod(this.m_implementationObject, reference);
    }

    void invokeUnbindMethod(DependencyManager dependencyManager, ServiceReference oldRef) {
        dependencyManager.invokeUnbindMethod(this.m_implementationObject, oldRef);
    }

    protected void setFactoryProperties(Dictionary dictionary) {
        this.m_factoryProperties = ImmediateComponentManager.copyTo(null, dictionary);
    }

    public boolean hasConfiguration() {
        return this.m_configurationProperties != null;
    }

    void registerComponentId() {
        super.registerComponentId();
        this.m_properties = null;
    }

    void unregisterComponentId() {
        super.unregisterComponentId();
        this.m_properties = null;
    }

    public Dictionary getProperties() {
        if (this.m_properties == null) {
            Dictionary props = ImmediateComponentManager.copyTo(null, this.getComponentMetadata().getProperties());
            List depMetaData = this.getComponentMetadata().getDependencies();
            for (ReferenceMetadata rm : depMetaData) {
                if (rm.getTarget() == null) continue;
                props.put(rm.getTargetPropertyName(), rm.getTarget());
            }
            ImmediateComponentManager.copyTo(props, this.m_configurationProperties);
            ImmediateComponentManager.copyTo(props, this.m_factoryProperties);
            props.put("component.name", this.getComponentMetadata().getName());
            props.put("component.id", new Long(this.getId()));
            this.m_properties = props;
        }
        return this.m_properties;
    }

    public void setServiceProperties(Dictionary serviceProperties) {
        if (serviceProperties == null || serviceProperties.isEmpty()) {
            this.m_serviceProperties = null;
        } else {
            this.m_serviceProperties = ImmediateComponentManager.copyTo(null, serviceProperties, false);
            this.m_serviceProperties.put("component.name", this.getComponentMetadata().getName());
            this.m_serviceProperties.put("component.id", new Long(this.getId()));
        }
        this.updateServiceRegistration();
    }

    public Dictionary getServiceProperties() {
        if (this.m_serviceProperties != null) {
            return this.m_serviceProperties;
        }
        return super.getServiceProperties();
    }

    private void updateServiceRegistration() {
        ServiceRegistration sr = this.getServiceRegistration();
        if (sr != null) {
            try {
                Dictionary regProps = this.getServiceProperties();
                if (!this.servicePropertiesMatches(sr, regProps)) {
                    sr.setProperties(regProps);
                }
            }
            catch (IllegalStateException ise) {
            }
            catch (IllegalArgumentException iae) {
                this.log(1, "Unexpected configuration property problem when updating service registration", iae);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem when updating service registration", t);
            }
        }
    }

    public void reconfigure(Dictionary configuration) {
        if (configuration == null && this.m_configurationProperties == null) {
            this.log(4, "No configuration provided (or deleted), nothing to do", null);
            return;
        }
        this.m_configurationProperties = configuration;
        this.m_properties = null;
        this.updateTargets(this.getProperties());
        if (this.getState() == 4 && configuration != null && !this.getComponentMetadata().isConfigurationIgnored()) {
            this.log(4, "Attempting to activate unsatisfied component", null);
            this.activateInternal();
            return;
        }
        if ((this.getState() & 0x70) == 0) {
            return;
        }
        if (configuration == null && this.getComponentMetadata().isConfigurationRequired()) {
            this.deactivateInternal(4, true);
        } else if (configuration == null | !this.modify()) {
            this.log(4, "Deactivating and Activating to reconfigure from configuration", null);
            int reason = configuration == null ? 4 : 3;
            this.deactivateInternal(reason, false);
            this.activateInternal();
        }
    }

    private boolean modify() {
        if (this.hasInstance()) {
            return false;
        }
        if (this.getComponentMetadata().getModified() == null) {
            return false;
        }
        Dictionary props = this.getProperties();
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (dm.canUpdateDynamically(props)) continue;
            this.log(4, "Cannot dynamically update the configuration due to dependency changes induced on dependency {0}", new Object[]{dm.getName()}, null);
            return false;
        }
        MethodResult result = this.invokeModifiedMethod();
        if (result == null) {
            this.log(1, "Declared modify method ''{0}'' cannot be found, configuring by reactivation", new Object[]{this.getComponentMetadata().getModified()}, null);
            return false;
        }
        if (!this.verifyDependencyManagers(props)) {
            this.log(1, "Updating the service references caused at least on reference to become unsatisfied, deactivating component", null);
            return false;
        }
        if (result.hasResult()) {
            this.setServiceProperties(result);
        } else {
            this.updateServiceRegistration();
        }
        return true;
    }

    protected MethodResult invokeModifiedMethod() {
        return this.getComponentMethods().getModifiedMethod().invoke(this.getInstance(), new ActivateMethod.ActivatorParameter(this.m_componentContext, -1), MethodResult.VOID);
    }

    protected boolean hasInstance() {
        return this.getInstance() == null;
    }

    private boolean servicePropertiesMatches(ServiceRegistration reg, Dictionary props) {
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        String[] keys = reg.getReference().getPropertyKeys();
        for (int i = 0; keys != null && i < keys.length; ++i) {
            if (keys[i].equals("objectClass") || keys[i].equals("service.id")) continue;
            ((Dictionary)regProps).put(keys[i], reg.getReference().getProperty(keys[i]));
        }
        return ((Object)regProps).equals(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        Object implementationObject = this.m_implementationObject;
        if (implementationObject == null) {
            try {
                if (!this.collectDependencies()) {
                    this.log(4, "getService did not win collecting dependencies, try creating object anyway.", null);
                } else {
                    this.log(4, "getService won collecting dependencies, proceed to creating object.", null);
                }
            }
            catch (IllegalStateException e) {
                this.log(3, "Could not obtain all required dependencies, getService returning null", null);
                return null;
            }
            this.obtainWriteLock("ImmediateComponentManager.getService.1");
            try {
                if (this.m_implementationObject == null) {
                    Object result = this.state().getService(this);
                    if (result != null) {
                        ++this.m_useCount;
                    }
                    Object object = result;
                    return object;
                }
                implementationObject = this.m_implementationObject;
            }
            finally {
                this.releaseWriteLock("ImmediateComponentManager.getService.1");
            }
        }
        ++this.m_useCount;
        return implementationObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object o) {
        if (this.m_useCount > 0) {
            --this.m_useCount;
            if (this.m_useCount == 0 && !this.isImmediate() && !this.getActivator().getConfiguration().keepInstances()) {
                this.obtainWriteLock("ImmediateComponentManager.ungetService.1");
                try {
                    if (this.m_useCount == 0) {
                        this.state().ungetService(this);
                        this.unsetDependencyMap();
                    }
                }
                finally {
                    this.releaseWriteLock("ImmediateComponentManager.ungetService.1");
                }
            }
        }
    }

    protected static interface SetImplementationObject {
        public void setImplementationObject(Object var1);
    }
}

