/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.tagsoup;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.Schema;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TidyMarkupDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final Logger LOG = LoggerFactory.getLogger(TidyMarkupDataFormat.class);
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String XML = "xml";
    private boolean omitXmlDeclaration;
    private Class<?> dataObjectType;
    private String method;
    private Schema parsingSchema;
    private Map<String, Boolean> parserFeatures;
    private Map<String, Object> parserProperties;

    public String getDataFormatName() {
        return "tidyMarkup";
    }

    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws Exception {
        throw new CamelException("Marshalling from Well Formed HTML to ugly HTML is not supported. Only unmarshal is supported");
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        ObjectHelper.notNull(this.dataObjectType, (String)"dataObjectType", (Object)((Object)this));
        if (this.dataObjectType.isAssignableFrom(Node.class)) {
            return this.asNodeTidyMarkup(inputStream);
        }
        if (this.dataObjectType.isAssignableFrom(String.class)) {
            return this.asStringTidyMarkup(inputStream);
        }
        throw new IllegalArgumentException("The return type [" + this.dataObjectType.getCanonicalName() + "] is unsupported");
    }

    public String asStringTidyMarkup(InputStream inputStream) throws CamelException {
        XMLReader parser = this.createTagSoupParser();
        StringWriter w = new StringWriter();
        parser.setContentHandler(this.createContentHandler(w));
        try {
            parser.parse(new InputSource(inputStream));
            String string = w.toString();
            return string;
        }
        catch (Exception e) {
            throw new CamelException("Failed to convert the HTML to tidy Markup", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close the inputStream");
            }
        }
    }

    public Node asNodeTidyMarkup(InputStream inputStream) throws CamelException {
        XMLReader parser = this.createTagSoupParser();
        StringWriter w = new StringWriter();
        parser.setContentHandler(this.createContentHandler(w));
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            transformer.transform(new SAXSource(parser, new InputSource(inputStream)), result);
            return result.getNode();
        }
        catch (Exception e) {
            throw new CamelException("Failed to convert the HTML to tidy Markup", (Throwable)e);
        }
    }

    protected XMLReader createTagSoupParser() throws CamelException {
        Parser reader = new Parser();
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            if (this.getParserFeatures() != null) {
                for (Map.Entry<String, Object> entry : this.getParserFeatures().entrySet()) {
                    reader.setFeature(entry.getKey(), (Boolean)entry.getValue());
                }
            }
            if (this.getParserProperties() != null) {
                for (Map.Entry<String, Object> entry : this.getParserProperties().entrySet()) {
                    reader.setProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.getParsingSchema() != null) {
                reader.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", this.getParsingSchema());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem configuring the parser", e);
        }
        return reader;
    }

    protected ContentHandler createContentHandler(Writer w) {
        XMLWriter xmlWriter = new XMLWriter(w);
        if (this.getMethod() != null) {
            xmlWriter.setOutputProperty("method", this.getMethod());
        } else {
            xmlWriter.setOutputProperty("method", XML);
        }
        if (this.omitXmlDeclaration) {
            xmlWriter.setOutputProperty("omit-xml-declaration", YES);
        } else {
            xmlWriter.setOutputProperty("omit-xml-declaration", NO);
        }
        return xmlWriter;
    }

    public void setParsingSchema(Schema schema) {
        this.parsingSchema = schema;
    }

    public Schema getParsingSchema() {
        if (this.parsingSchema == null) {
            this.parsingSchema = new HTMLSchema();
        }
        return this.parsingSchema;
    }

    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    public void setParserFeatures(Map<String, Boolean> parserFeatures) {
        this.parserFeatures = parserFeatures;
    }

    public Map<String, Boolean> getParserFeatures() {
        return this.parserFeatures;
    }

    public void setParserProperties(Map<String, Object> parserProperties) {
        this.parserProperties = parserProperties;
    }

    public Map<String, Object> getParserProperties() {
        return this.parserProperties;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public Class<?> getDataObjectType() {
        return this.dataObjectType;
    }

    public void setDataObjectType(Class<?> dataObjectType) {
        this.dataObjectType = dataObjectType;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

