/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elsql;

import com.opengamma.elsql.ElSql;
import com.opengamma.elsql.SpringSqlParams;
import com.opengamma.elsql.SqlParams;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.elsql.ElsqlEndpoint;
import org.apache.camel.component.elsql.ElsqlSqlMapSource;
import org.apache.camel.component.sql.ResultSetIterator;
import org.apache.camel.component.sql.ResultSetIteratorCompletion;
import org.apache.camel.component.sql.SqlOutputType;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.JdbcUtils;

public class ElsqlProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElsqlProducer.class);
    private final ElSql elSql;
    private final String elSqlName;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final DataSource dataSource;

    public ElsqlProducer(ElsqlEndpoint endpoint, ElSql elSql, String elSqlName, NamedParameterJdbcTemplate jdbcTemplate, DataSource dataSource) {
        super((Endpoint)endpoint);
        this.elSql = elSql;
        this.elSqlName = elSqlName;
        this.jdbcTemplate = jdbcTemplate;
        this.dataSource = dataSource;
    }

    public ElsqlEndpoint getEndpoint() {
        return (ElsqlEndpoint)super.getEndpoint();
    }

    public void process(final Exchange exchange) throws Exception {
        Object data = exchange.getIn().getBody();
        ElsqlSqlMapSource param = new ElsqlSqlMapSource(exchange, data);
        String sql = this.elSql.getSql(this.elSqlName, (SqlParams)new SpringSqlParams((SqlParameterSource)param));
        LOG.debug("ElsqlProducer @{} using sql: {}", (Object)this.elSqlName, (Object)sql);
        SqlOutputType outputType = this.getEndpoint().getOutputType();
        if (outputType == SqlOutputType.StreamList) {
            this.processStreamList(exchange, sql, (SqlParameterSource)param);
            return;
        }
        this.log.trace("jdbcTemplate.execute: {}", (Object)sql);
        this.jdbcTemplate.execute(sql, (SqlParameterSource)param, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSet rs;
                block18: {
                    rs = null;
                    try {
                        boolean isResultSet = ps.execute();
                        if (isResultSet) {
                            rs = ps.getResultSet();
                            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                            SqlOutputType outputType = ElsqlProducer.this.getEndpoint().getOutputType();
                            ElsqlProducer.this.log.trace("Got result list from query: {}, outputType={}", (Object)rs, (Object)outputType);
                            if (outputType == SqlOutputType.SelectList) {
                                List data = ElsqlProducer.this.getEndpoint().queryForList(rs, true);
                                if (ElsqlProducer.this.getEndpoint().isNoop()) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                } else if (ElsqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                    exchange.getOut().setHeader(ElsqlProducer.this.getEndpoint().getOutputHeader(), (Object)data);
                                } else {
                                    exchange.getOut().setBody((Object)data);
                                }
                                exchange.getOut().setHeader("CamelSqlRowCount", (Object)data.size());
                                break block18;
                            }
                            if (outputType == SqlOutputType.SelectOne) {
                                Object data = ElsqlProducer.this.getEndpoint().queryForObject(rs);
                                if (data != null) {
                                    if (ElsqlProducer.this.getEndpoint().isNoop()) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                    } else if (ElsqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                        exchange.getOut().setHeader(ElsqlProducer.this.getEndpoint().getOutputHeader(), data);
                                    } else {
                                        exchange.getOut().setBody(data);
                                    }
                                    exchange.getOut().setHeader("CamelSqlRowCount", (Object)1);
                                } else {
                                    if (ElsqlProducer.this.getEndpoint().isNoop()) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                    } else if (ElsqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                    }
                                    exchange.getOut().setHeader("CamelSqlRowCount", (Object)0);
                                }
                                break block18;
                            }
                            throw new IllegalArgumentException("Invalid outputType=" + outputType);
                        }
                        exchange.getOut().setHeader("CamelSqlUpdateCount", (Object)ps.getUpdateCount());
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return null;
            }
        });
    }

    protected void processStreamList(Exchange exchange, String sql, SqlParameterSource param) throws Exception {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)param);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)param, null);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)param);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        PreparedStatementCreator statementCreator = pscf.newPreparedStatementCreator(params);
        this.processStreamList(exchange, statementCreator, sqlToUse);
    }

    protected void processStreamList(Exchange exchange, PreparedStatementCreator statementCreator, String preparedQuery) throws Exception {
        this.log.trace("processStreamList: {}", (Object)preparedQuery);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.dataSource.getConnection();
            ps = statementCreator.createPreparedStatement(con);
            boolean isResultSet = ps.execute();
            if (isResultSet) {
                rs = ps.getResultSet();
                ResultSetIterator iterator = this.getEndpoint().queryForStreamList(con, ps, rs);
                if (this.getEndpoint().isNoop()) {
                    exchange.getOut().setBody(exchange.getIn().getBody());
                } else if (this.getEndpoint().getOutputHeader() != null) {
                    exchange.getOut().setBody(exchange.getIn().getBody());
                    exchange.getOut().setHeader(this.getEndpoint().getOutputHeader(), (Object)iterator);
                } else {
                    exchange.getOut().setBody((Object)iterator);
                }
                exchange.addOnCompletion((Synchronization)new ResultSetIteratorCompletion(iterator));
            }
        }
        catch (Exception e) {
            JdbcUtils.closeConnection((Connection)con);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeResultSet(rs);
            throw e;
        }
    }
}

