/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.beanio.RecordContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorContext
implements RecordContext,
Cloneable {
    private int lineNumber;
    private String recordText;
    private String recordName;
    private ArrayList<String> recordErrors;
    private HashMap<String, String> fieldTextMap;
    private HashMap<String, Counter> fieldCountMap;
    private HashMap<String, Collection<String>> fieldErrorMap;

    public void clear() {
        this.lineNumber = 0;
        this.recordName = null;
        this.recordText = null;
        if (this.fieldTextMap != null) {
            this.fieldTextMap.clear();
        }
        if (this.fieldCountMap != null) {
            this.fieldCountMap.clear();
        }
        if (this.fieldErrorMap != null) {
            this.fieldErrorMap = null;
        }
        if (this.recordErrors != null) {
            this.recordErrors.clear();
        }
    }

    @Override
    public String getRecordText() {
        return this.recordText;
    }

    public void setRecordText(String text) {
        this.recordText = text;
    }

    @Override
    public int getRecordLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        if (lineNumber > 0) {
            this.lineNumber = lineNumber;
        }
    }

    @Override
    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public void addFieldError(String fieldName, String message) {
        Collection<String> errors;
        if (this.fieldErrorMap == null) {
            this.fieldErrorMap = new HashMap();
        }
        if ((errors = this.fieldErrorMap.get(fieldName)) == null) {
            errors = new ArrayList<String>();
            errors.add(message);
            this.fieldErrorMap.put(fieldName, errors);
        } else {
            errors.add(message);
        }
    }

    public void addRecordError(String message) {
        if (this.recordErrors == null) {
            this.recordErrors = new ArrayList(3);
        }
        this.recordErrors.add(message);
    }

    public void setFieldText(String fieldName, String text, boolean repeating) {
        if (this.fieldTextMap == null) {
            this.fieldTextMap = new HashMap();
        }
        if (repeating) {
            Counter counter;
            if (this.fieldCountMap == null) {
                this.fieldCountMap = new HashMap();
            }
            if ((counter = this.fieldCountMap.get(fieldName)) == null) {
                counter = new Counter();
                this.fieldCountMap.put(fieldName, counter);
            }
            this.fieldTextMap.put(counter.getCount() + ":" + fieldName, text);
            counter.incrementCount();
        } else {
            this.fieldTextMap.put(fieldName, text);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.hasRecordErrors() || this.hasFieldErrors();
    }

    @Override
    public boolean hasRecordErrors() {
        return this.recordErrors != null && !this.recordErrors.isEmpty();
    }

    @Override
    public Collection<String> getRecordErrors() {
        if (this.recordErrors == null) {
            return Collections.emptyList();
        }
        return this.recordErrors;
    }

    @Override
    public int getFieldCount(String fieldName) {
        Counter counter;
        if (this.fieldTextMap == null) {
            return 0;
        }
        if (this.fieldCountMap != null && (counter = this.fieldCountMap.get(fieldName)) != null) {
            return counter.getCount();
        }
        return this.fieldTextMap.containsKey(fieldName) ? 1 : 0;
    }

    @Override
    public String getFieldText(String fieldName) {
        return this.getFieldText(fieldName, 0);
    }

    @Override
    public String getFieldText(String fieldName, int index) {
        if (this.fieldTextMap == null) {
            return null;
        }
        if (index == 0) {
            return this.fieldTextMap.get(fieldName);
        }
        return this.fieldTextMap.get(index + ":" + fieldName);
    }

    @Override
    public boolean hasFieldErrors() {
        return this.fieldErrorMap != null && !this.fieldErrorMap.isEmpty();
    }

    @Override
    public Map<String, Collection<String>> getFieldErrors() {
        if (this.fieldErrorMap == null) {
            return Collections.emptyMap();
        }
        return this.fieldErrorMap;
    }

    @Override
    public Collection<String> getFieldErrors(String fieldName) {
        if (this.fieldErrorMap == null) {
            return null;
        }
        return this.fieldErrorMap.get(fieldName);
    }

    @Override
    public int getLineNumber() {
        return this.getRecordLineNumber();
    }

    private static class Counter {
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }
    }
}

