/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.beanio.internal.parser.Aggregation;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.ObjectUtils;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapParser
extends Aggregation {
    private Class<? extends Map<Object, Object>> type;
    private Property key;
    private ParserLocal<Object> value = new ParserLocal();

    @Override
    public void clearValue(ParsingContext context) {
        this.value.set(context, null);
    }

    @Override
    public boolean defines(Object value) {
        if (value == null || this.type == null) {
            return false;
        }
        return Map.class.isAssignableFrom(value.getClass());
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean marshal(MarshallingContext context, Parser delegate, int minOccurs, int maxOccurs) throws IOException {
        context.pushIteration(this);
        try {
            Map<Object, Object> map = this.getMap(context);
            if (map == null && minOccurs == 0) {
                boolean bl = false;
                return bl;
            }
            int i = 0;
            if (map != null) {
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    if (i < maxOccurs) {
                        this.setIterationIndex(context, i);
                        this.key.setValue(context, entry.getKey());
                        delegate.setValue(context, entry.getValue());
                        delegate.marshal(context);
                        ++i;
                        continue;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (i < minOccurs) {
                this.key.setValue(context, null);
                delegate.setValue(context, null);
                while (i < minOccurs) {
                    this.setIterationIndex(context, i);
                    delegate.marshal(context);
                    ++i;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            context.popIteration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean unmarshal(UnmarshallingContext context, Parser delegate, int minOccurs, int maxOccurs) {
        Object value;
        Map<Object, Object> map = this.lazy ? null : this.createMap();
        boolean invalid = false;
        int count = 0;
        try {
            context.pushIteration(this);
            Object fieldValue = null;
            for (int i = 0; i < maxOccurs; ++i) {
                this.setIterationIndex(context, i);
                boolean found = delegate.unmarshal(context);
                if (!found) {
                    delegate.clearValue(context);
                    break;
                }
                fieldValue = delegate.getValue(context);
                if (fieldValue == Value.INVALID) {
                    invalid = true;
                } else if (fieldValue != Value.MISSING) {
                    Object mapKey = this.key.getValue(context);
                    if (!this.lazy || StringUtil.hasValue(mapKey) || StringUtil.hasValue(fieldValue)) {
                        if (map == null) {
                            map = this.createMap();
                        }
                        map.put(mapKey, fieldValue);
                    }
                }
                delegate.clearValue(context);
                ++count;
            }
        }
        finally {
            context.popIteration();
        }
        if (count < minOccurs) {
            context.addFieldError(this.getName(), null, "minOccurs", minOccurs, maxOccurs);
            value = Value.INVALID;
        } else {
            value = invalid ? Value.INVALID : map;
        }
        this.value.set(context, value);
        return count > 0;
    }

    @Override
    public boolean isProperty() {
        return this.type != null;
    }

    public Class<? extends Map<Object, Object>> getType() {
        return this.type;
    }

    @Override
    public void setType(Class<?> mapType) {
        this.type = mapType;
    }

    @Override
    public Object createValue(ParsingContext context) {
        Map<Object, Object> value = this.value.get(context);
        if (value == null) {
            value = this.createMap();
            this.value.set(context, value);
        }
        return this.getValue(context);
    }

    @Override
    public Object getValue(ParsingContext context) {
        Object value = this.value.get(context);
        return value == null ? Value.MISSING : value;
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (value != null && ((Map)value).isEmpty()) {
            value = null;
        }
        this.value.set(context, value);
        super.setValue(context, value);
    }

    protected Map<Object, Object> createMap() {
        return ObjectUtils.newInstance(this.type);
    }

    protected Map<Object, Object> getMap(ParsingContext context) {
        Object value = this.value.get(context);
        if (value == Value.INVALID) {
            return null;
        }
        return (Map)value;
    }

    @Override
    protected int length(Object value) {
        Map map = (Map)value;
        return map != null ? map.size() : 0;
    }

    @Override
    public int getIterationSize() {
        return this.getSize();
    }

    @Override
    public int type() {
        return 6;
    }

    @Override
    public void registerLocals(Set<ParserLocal<? extends Object>> locals) {
        if (this.key != null) {
            ((Component)((Object)this.key)).registerLocals(locals);
        }
        if (locals.add(this.value)) {
            super.registerLocals(locals);
        }
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        Map<Object, Object> map = this.getMap(context);
        return map != null && map.size() > 0;
    }

    public Property getKey() {
        return this.key;
    }

    public void setKey(Property key) {
        this.key = key;
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        if (this.key != null) {
            s.append(", key=$").append(this.key.getName());
        }
        if (this.type != null) {
            s.append(", type=").append(this.type.getSimpleName());
        }
    }
}

