/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.beanio.BeanReaderException;
import org.beanio.InvalidRecordException;
import org.beanio.MalformedRecordException;
import org.beanio.RecordContext;
import org.beanio.UnexpectedRecordException;
import org.beanio.UnidentifiedRecordException;
import org.beanio.Unmarshaller;
import org.beanio.internal.parser.AbortRecordUnmarshalligException;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.beanio.stream.RecordUnmarshaller;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshallerImpl
implements Unmarshaller {
    private Selector layout;
    private UnmarshallingContext context;
    private String recordName;
    private String recordText;
    private Object recordValue;

    public UnmarshallerImpl(UnmarshallingContext context, Selector layout, final RecordUnmarshaller recordUnmarshaller) {
        this.context = context;
        this.layout = layout;
        this.context.setRecordReader(new RecordReader(){

            public Object read() throws RecordIOException {
                try {
                    Object value = UnmarshallerImpl.this.recordValue;
                    if (UnmarshallerImpl.this.recordText != null) {
                        value = recordUnmarshaller.unmarshal(UnmarshallerImpl.this.recordText);
                    }
                    Object object = value;
                    return object;
                }
                finally {
                    UnmarshallerImpl.this.recordText = null;
                    UnmarshallerImpl.this.recordValue = null;
                }
            }

            public int getRecordLineNumber() {
                return 0;
            }

            public String getRecordText() {
                return UnmarshallerImpl.this.recordText;
            }

            public void close() throws IOException {
            }
        });
    }

    @Override
    public Object unmarshal(String text) throws MalformedRecordException, UnidentifiedRecordException, UnexpectedRecordException, InvalidRecordException {
        if (text == null) {
            throw new NullPointerException("null text");
        }
        this.recordName = null;
        this.recordText = text;
        return this.unmarshal();
    }

    @Override
    public Object unmarshal(List<String> list) throws BeanReaderException, UnidentifiedRecordException, UnexpectedRecordException, InvalidRecordException {
        if (list == null) {
            throw new NullPointerException("null list");
        }
        this.recordName = null;
        this.recordValue = this.context.toRecordValue(list);
        if (this.recordValue == null) {
            throw new BeanReaderException("unmarshal(List) not supported by stream format");
        }
        return this.unmarshal();
    }

    @Override
    public Object unmarshal(String[] array) throws BeanReaderException, UnidentifiedRecordException, UnexpectedRecordException, InvalidRecordException {
        if (array == null) {
            throw new NullPointerException("null array");
        }
        this.recordName = null;
        this.recordValue = this.context.toRecordValue(array);
        if (this.recordValue == null) {
            throw new BeanReaderException("unmarshal(String[]) not supported by stream format");
        }
        return this.unmarshal();
    }

    @Override
    public Object unmarshal(Node node) throws BeanReaderException, UnidentifiedRecordException, UnexpectedRecordException, InvalidRecordException {
        if (node == null) {
            throw new NullPointerException("null node");
        }
        this.recordName = null;
        this.recordValue = this.context.toRecordValue(node);
        if (this.recordValue == null) {
            throw new BeanReaderException("unmarshal(Node) not supported by stream format");
        }
        return this.unmarshal();
    }

    private Object unmarshal() {
        this.context.nextRecord();
        Selector parser = null;
        try {
            parser = this.layout.matchNext(this.context);
        }
        catch (UnexpectedRecordException ex) {
            // empty catch block
        }
        if (parser == null) {
            parser = this.layout.matchAny(this.context);
            if (parser != null) {
                throw this.context.recordUnexpectedException(parser.getName());
            }
            throw this.context.recordUnidentifiedException();
        }
        this.recordName = parser.getName();
        try {
            if (parser.isRecordGroup()) {
                this.context.recordSkipped();
                throw new BeanReaderException("Record groups not supported by Unmarshallers");
            }
            this.context.prepare(parser.getName(), false);
            try {
                parser.unmarshal(this.context);
            }
            catch (AbortRecordUnmarshalligException abortRecordUnmarshalligException) {
                // empty catch block
            }
            this.context.validate();
            Object object = parser.getValue(this.context);
            return object;
        }
        finally {
            if (parser != null) {
                parser.clearValue(this.context);
            }
        }
    }

    @Override
    public String getRecordName() {
        return this.recordName;
    }

    @Override
    public RecordContext getRecordContext() {
        return this.context.getRecordContext(0);
    }

    @Override
    public void debug() {
        this.debug(System.out);
    }

    @Override
    public void debug(PrintStream out) {
        ((Component)((Object)this.layout)).print(out);
    }
}

