/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.fixedlength;

import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.format.fixedlength.FixedLengthUnmarshallingContext;

public class FixedLengthRecordFormat
implements RecordFormat {
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private int minMatchLength = 0;
    private int maxMatchLength = Integer.MAX_VALUE;

    public boolean matches(UnmarshallingContext context) {
        int length = ((FixedLengthUnmarshallingContext)context).getRecordLength();
        return length >= this.minMatchLength && length <= this.maxMatchLength;
    }

    public void validate(UnmarshallingContext context) {
        int length = ((FixedLengthUnmarshallingContext)context).getRecordLength();
        if (length < this.minLength) {
            context.addRecordError("minLength", this.minLength, this.maxLength);
        }
        if (length > this.maxLength) {
            context.addRecordError("maxLength", this.minLength, this.maxLength);
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinMatchLength() {
        return this.minMatchLength;
    }

    public void setMinMatchLength(int minMatchLength) {
        this.minMatchLength = minMatchLength;
    }

    public int getMaxMatchLength() {
        return this.maxMatchLength;
    }

    public void setMaxMatchLength(int maxMatchLength) {
        this.maxMatchLength = maxMatchLength;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName()).append("[");
        s.append("recordLength=").append(this.minLength).append('-').append(this.maxLength);
        s.append("]");
        return s.toString();
    }
}

