/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.json.JsonParserConfiguration;
import org.beanio.stream.json.JsonWriterSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRecordMarshaller
extends JsonWriterSupport
implements RecordMarshaller {
    private StringWriter out = new StringWriter();

    public JsonRecordMarshaller() {
        this(new JsonParserConfiguration());
    }

    public JsonRecordMarshaller(JsonParserConfiguration config) {
        this.init(this.out, config);
    }

    @Override
    public String marshal(Object record) {
        return this.marshal((Map)record);
    }

    public String marshal(Map<String, Object> map) {
        try {
            super.write(map);
            String string = this.out.toString();
            return string;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected IOException caught", ex);
        }
        finally {
            this.out.clear();
        }
    }

    private static class StringWriter
    extends Writer {
        private StringBuilder text = new StringBuilder();

        private StringWriter() {
        }

        public void write(char[] cbuf, int off, int len) {
            this.text.append(cbuf, off, len);
        }

        public void write(int c) {
            this.text.append((char)c);
        }

        public void write(char[] cbuf) {
            this.text.append(cbuf, 0, cbuf.length);
        }

        public void flush() {
        }

        public void close() {
        }

        public void clear() {
            this.text = new StringBuilder();
        }

        public String toString() {
            return this.text.toString();
        }
    }
}

