/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class AesGcmContentEncryptionAlgorithm
extends AbstractContentEncryptionAlgorithm {
    private static final int DEFAULT_IV_SIZE = 96;

    public AesGcmContentEncryptionAlgorithm(ContentAlgorithm algo) {
        this((byte[])null, null, algo);
    }

    public AesGcmContentEncryptionAlgorithm(String encodedCek, String encodedIv, ContentAlgorithm algo) {
        this(CryptoUtils.decodeSequence((String)encodedCek), CryptoUtils.decodeSequence((String)encodedIv), algo);
    }

    public AesGcmContentEncryptionAlgorithm(String encodedCek, ContentAlgorithm algo) {
        this(CryptoUtils.decodeSequence((String)encodedCek), null, algo);
    }

    public AesGcmContentEncryptionAlgorithm(SecretKey key, ContentAlgorithm algo) {
        this(key, (byte[])null, algo);
    }

    public AesGcmContentEncryptionAlgorithm(SecretKey key, byte[] iv, ContentAlgorithm algo) {
        this(key.getEncoded(), iv, algo);
    }

    public AesGcmContentEncryptionAlgorithm(byte[] cek, ContentAlgorithm algo) {
        this(cek, (byte[])null, algo);
    }

    public AesGcmContentEncryptionAlgorithm(byte[] cek, byte[] iv, ContentAlgorithm algo) {
        super(cek, iv, AesGcmContentEncryptionAlgorithm.checkAlgorithm(algo));
    }

    @Override
    protected int getIvSize() {
        return 96;
    }

    private static ContentAlgorithm checkAlgorithm(ContentAlgorithm algo) {
        if (AlgorithmUtils.isAesGcm(algo.getJwaName())) {
            return algo;
        }
        LOG.warning("Invalid content encryption algorithm");
        throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
    }
}

