/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.JwtTokenUtils;

public class JCacheOAuthDataProvider
extends AbstractOAuthDataProvider {
    public static final String CLIENT_CACHE_KEY = "cxf.oauth2.client.cache";
    public static final String ACCESS_TOKEN_CACHE_KEY = "cxf.oauth2.accesstoken.cache";
    public static final String REFRESH_TOKEN_CACHE_KEY = "cxf.oauth2.refreshtoken.cache";
    public static final String DEFAULT_CONFIG_URL = "cxf-oauth2-ehcache3.xml";
    protected final CacheManager cacheManager;
    private final Cache<String, Client> clientCache;
    private Cache<String, ServerAccessToken> accessTokenCache;
    private Cache<String, String> jwtAccessTokenCache;
    private final Cache<String, RefreshToken> refreshTokenCache;
    private boolean storeJwtTokenKeyOnly;
    private JoseJwtConsumer jwtTokenConsumer;

    public JCacheOAuthDataProvider() throws Exception {
        this(false);
    }

    public JCacheOAuthDataProvider(boolean storeJwtTokenKeyOnly) throws Exception {
        this(DEFAULT_CONFIG_URL, BusFactory.getThreadDefaultBus((boolean)true));
    }

    public JCacheOAuthDataProvider(String configFileURL, Bus bus) throws Exception {
        this(configFileURL, bus, false);
    }

    public JCacheOAuthDataProvider(String configFileURL, Bus bus, boolean storeJwtTokenKeyOnly) throws Exception {
        this(configFileURL, bus, CLIENT_CACHE_KEY, ACCESS_TOKEN_CACHE_KEY, REFRESH_TOKEN_CACHE_KEY, storeJwtTokenKeyOnly);
    }

    public JCacheOAuthDataProvider(String configFileURL, Bus bus, String clientCacheKey, String accessTokenCacheKey, String refreshTokenCacheKey) throws Exception {
        this(configFileURL, bus, clientCacheKey, accessTokenCacheKey, refreshTokenCacheKey, false);
    }

    public JCacheOAuthDataProvider(String configFileURL, Bus bus, String clientCacheKey, String accessTokenCacheKey, String refreshTokenCacheKey, boolean storeJwtTokenKeyOnly) throws Exception {
        this.cacheManager = JCacheOAuthDataProvider.createCacheManager(configFileURL, bus);
        this.clientCache = JCacheOAuthDataProvider.createCache(this.cacheManager, clientCacheKey, String.class, Client.class);
        this.storeJwtTokenKeyOnly = storeJwtTokenKeyOnly;
        if (storeJwtTokenKeyOnly) {
            this.jwtAccessTokenCache = JCacheOAuthDataProvider.createCache(this.cacheManager, accessTokenCacheKey, String.class, String.class);
        } else {
            this.accessTokenCache = JCacheOAuthDataProvider.createCache(this.cacheManager, accessTokenCacheKey, String.class, ServerAccessToken.class);
        }
        this.refreshTokenCache = JCacheOAuthDataProvider.createCache(this.cacheManager, refreshTokenCacheKey, String.class, RefreshToken.class);
    }

    @Override
    public Client getClient(String clientId) throws OAuthServiceException {
        return (Client)this.clientCache.get((Object)clientId);
    }

    @Override
    public void setClient(Client client) {
        this.clientCache.put((Object)client.getClientId(), (Object)client);
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.clientCache.remove((Object)c.getClientId());
    }

    @Override
    public List<Client> getClients(UserSubject resourceOwner) {
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Cache.Entry entry : this.clientCache) {
            Client client = (Client)entry.getValue();
            if (!JCacheOAuthDataProvider.isClientMatched(client, resourceOwner)) continue;
            clients.add(client);
        }
        return clients;
    }

    @Override
    public List<ServerAccessToken> getAccessTokens(Client c, UserSubject sub) {
        if (this.isUseJwtFormatForAccessTokens() && this.isStoreJwtTokenKeyOnly()) {
            return this.getJwtAccessTokens(c, sub);
        }
        return JCacheOAuthDataProvider.getTokens(this.accessTokenCache, c, sub);
    }

    @Override
    public List<RefreshToken> getRefreshTokens(Client c, UserSubject sub) {
        return JCacheOAuthDataProvider.getTokens(this.refreshTokenCache, c, sub);
    }

    @Override
    public ServerAccessToken getAccessToken(String accessTokenKey) throws OAuthServiceException {
        if (this.isUseJwtFormatForAccessTokens() && this.isStoreJwtTokenKeyOnly()) {
            return this.getJwtAccessToken(accessTokenKey);
        }
        return JCacheOAuthDataProvider.getToken(this.accessTokenCache, accessTokenKey);
    }

    @Override
    protected void doRevokeAccessToken(ServerAccessToken at) {
        this.accessTokenCache.remove((Object)at.getTokenKey());
    }

    @Override
    protected RefreshToken getRefreshToken(String refreshTokenKey) {
        return JCacheOAuthDataProvider.getToken(this.refreshTokenCache, refreshTokenKey);
    }

    @Override
    protected void doRevokeRefreshToken(RefreshToken rt) {
        this.refreshTokenCache.remove((Object)rt.getTokenKey());
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverToken) {
        if (this.isUseJwtFormatForAccessTokens() && this.isStoreJwtTokenKeyOnly()) {
            this.jwtAccessTokenCache.put((Object)serverToken.getTokenKey(), (Object)serverToken.getTokenKey());
        } else {
            this.accessTokenCache.put((Object)serverToken.getTokenKey(), (Object)serverToken);
        }
    }

    @Override
    protected void saveRefreshToken(RefreshToken refreshToken) {
        this.refreshTokenCache.put((Object)refreshToken.getTokenKey(), (Object)refreshToken);
    }

    @Override
    public void close() {
        this.clientCache.close();
        this.refreshTokenCache.close();
        if (this.accessTokenCache != null) {
            this.accessTokenCache.close();
        } else {
            this.jwtAccessTokenCache.close();
        }
        this.cacheManager.close();
    }

    protected static <V extends ServerAccessToken> V getToken(Cache<String, V> cache, String key) {
        ServerAccessToken token = (ServerAccessToken)cache.get((Object)key);
        if (token != null && JCacheOAuthDataProvider.isExpired(token)) {
            cache.remove((Object)key);
            token = null;
        }
        return (V)token;
    }

    protected ServerAccessToken getJwtAccessToken(String key) {
        JoseJwtConsumer theConsumer;
        String jose = (String)this.jwtAccessTokenCache.get((Object)key);
        ServerAccessToken token = null;
        if (jose != null && JCacheOAuthDataProvider.isExpired(token = JwtTokenUtils.createAccessTokenFromJwt(theConsumer = this.jwtTokenConsumer == null ? new JoseJwtConsumer() : this.jwtTokenConsumer, jose, this, super.getJwtAccessTokenClaimMap()))) {
            this.jwtAccessTokenCache.remove((Object)key);
            token = null;
        }
        return token;
    }

    protected static <K, V extends ServerAccessToken> List<V> getTokens(Cache<K, V> cache, Client client, UserSubject sub) {
        HashSet<Object> toRemove = new HashSet<Object>();
        ArrayList<ServerAccessToken> tokens = new ArrayList<ServerAccessToken>();
        for (Cache.Entry entry : cache) {
            ServerAccessToken token = (ServerAccessToken)entry.getValue();
            if (!JCacheOAuthDataProvider.isExpired(token)) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (!JCacheOAuthDataProvider.isTokenMatched(token, client, sub)) continue;
            tokens.add(token);
        }
        cache.removeAll(toRemove);
        return tokens;
    }

    protected List<ServerAccessToken> getJwtAccessTokens(Client client, UserSubject sub) {
        HashSet<Object> toRemove = new HashSet<Object>();
        ArrayList<ServerAccessToken> tokens = new ArrayList<ServerAccessToken>();
        Iterator it = this.jwtAccessTokenCache.iterator();
        while (it.hasNext()) {
            Cache.Entry entry;
            String jose;
            JoseJwtConsumer theConsumer = this.jwtTokenConsumer == null ? new JoseJwtConsumer() : this.jwtTokenConsumer;
            ServerAccessToken token = JwtTokenUtils.createAccessTokenFromJwt(theConsumer, jose = (String)(entry = (Cache.Entry)it.next()).getValue(), this, super.getJwtAccessTokenClaimMap());
            if (!JCacheOAuthDataProvider.isExpired(token)) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (!JCacheOAuthDataProvider.isTokenMatched(token, client, sub)) continue;
            tokens.add(token);
        }
        this.jwtAccessTokenCache.removeAll(toRemove);
        return tokens;
    }

    protected static boolean isExpired(ServerAccessToken token) {
        return System.currentTimeMillis() < token.getIssuedAt() + token.getExpiresIn();
    }

    protected static CacheManager createCacheManager(String configFile, Bus bus) throws Exception {
        URI configFileURI;
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        CachingProvider provider = Caching.getCachingProvider();
        try {
            configFileURI = ResourceUtils.getClasspathResourceURL((String)configFile, JCacheOAuthDataProvider.class, (Bus)bus).toURI();
        }
        catch (Exception ex) {
            configFileURI = provider.getDefaultURI();
        }
        return provider.getCacheManager(configFileURI, Thread.currentThread().getContextClassLoader());
    }

    protected static <K, V> Cache<K, V> createCache(CacheManager cacheManager, String cacheKey, Class<K> keyType, Class<V> valueType) {
        Cache cache = cacheManager.getCache(cacheKey, keyType, valueType);
        if (cache == null) {
            cache = cacheManager.createCache(cacheKey, (Configuration)new MutableConfiguration().setTypes(keyType, valueType).setStoreByValue(true).setStatisticsEnabled(false));
        }
        return cache;
    }

    public boolean isStoreJwtTokenKeyOnly() {
        return this.storeJwtTokenKeyOnly;
    }

    public void setJwtTokenConsumer(JoseJwtConsumer jwtTokenConsumer) {
        this.jwtTokenConsumer = jwtTokenConsumer;
    }
}

