/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.paho.PahoComponent;
import org.apache.camel.component.paho.PahoConsumer;
import org.apache.camel.component.paho.PahoMessage;
import org.apache.camel.component.paho.PahoPersistence;
import org.apache.camel.component.paho.PahoProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="paho", title="Paho", consumerClass=PahoConsumer.class, label="messaging,iot", syntax="paho:topic")
public class PahoEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PahoEndpoint.class);
    @UriPath
    @Metadata(required="true")
    private String topic;
    @UriParam
    private String clientId = "camel-" + System.nanoTime();
    @UriParam(defaultValue="tcp://localhost:1883")
    private String brokerUrl = "tcp://localhost:1883";
    @UriParam(defaultValue="2")
    private int qos = 2;
    @UriParam(defaultValue="false")
    private boolean retained;
    @UriParam(defaultValue="MEMORY")
    private PahoPersistence persistence = PahoPersistence.MEMORY;
    @UriParam(description="Base directory used by file persistence.", defaultValue="Current directory")
    private String filePersistenceDirectory;
    @UriParam
    private MqttConnectOptions connectOptions;
    private transient MqttClient client;

    public PahoEndpoint(String uri, String topic, Component component) {
        super(uri, component);
        this.topic = topic;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = new MqttClient(this.getBrokerUrl(), this.getClientId(), this.resolvePersistence());
        this.client.connect(this.resolveMqttConnectOptions());
    }

    protected void doStop() throws Exception {
        if (this.getClient().isConnected()) {
            this.getClient().disconnect();
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new PahoProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new PahoConsumer((Endpoint)this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public PahoComponent getComponent() {
        return (PahoComponent)super.getComponent();
    }

    protected MqttClientPersistence resolvePersistence() {
        if (this.persistence == PahoPersistence.MEMORY) {
            return new MemoryPersistence();
        }
        if (this.filePersistenceDirectory != null) {
            return new MqttDefaultFilePersistence(this.filePersistenceDirectory);
        }
        return new MqttDefaultFilePersistence();
    }

    protected MqttConnectOptions resolveMqttConnectOptions() {
        if (this.connectOptions != null) {
            return this.connectOptions;
        }
        Set connectOptions = this.getCamelContext().getRegistry().findByType(MqttConnectOptions.class);
        if (connectOptions.size() == 1) {
            LOG.info("Single MqttConnectOptions instance found in the registry. It will be used by the endpoint.");
            return (MqttConnectOptions)connectOptions.iterator().next();
        }
        if (connectOptions.size() > 1) {
            LOG.warn("Found {} instances of the MqttConnectOptions in the registry. None of these will be used by the endpoint. Please use 'connectOptions' endpoint option to select one.", (Object)connectOptions.size());
        }
        return new MqttConnectOptions();
    }

    public Exchange createExchange(MqttMessage mqttMessage, String topic) {
        PahoMessage paho = new PahoMessage();
        paho.setMqttMessage(mqttMessage);
        paho.setBody(mqttMessage.getPayload());
        paho.setHeader("CamelMqttTopic", topic);
        Exchange exchange = this.createExchange();
        exchange.setIn((Message)paho);
        return exchange;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean retained) {
        this.retained = retained;
    }

    public PahoPersistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(PahoPersistence persistence) {
        this.persistence = persistence;
    }

    public String getFilePersistenceDirectory() {
        return this.filePersistenceDirectory;
    }

    public void setFilePersistenceDirectory(String filePersistenceDirectory) {
        this.filePersistenceDirectory = filePersistenceDirectory;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }

    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public void setConnectOptions(MqttConnectOptions connOpts) {
        this.connectOptions = connOpts;
    }
}

