/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;

@XmlType(propOrder={"patchId", "oneoffId", "dependencies", "postCommands"})
@XmlRootElement(name="package")
public final class PatchMetadataModel {
    private String patchId;
    private String oneoffId;
    private Roles roles;
    private Dependencies dependencies;
    private Commands postCommands;

    public static PatchMetadataModel fromPatchMetadata(PatchMetadata metadata) {
        PatchMetadataModel model = new PatchMetadataModel();
        model.patchId = metadata.getPatchId().toString();
        model.oneoffId = metadata.getOneoffId() != null ? metadata.getOneoffId().toString() : null;
        model.roles = new Roles(metadata.getRoles());
        model.dependencies = new Dependencies(metadata.getDependencies());
        model.postCommands = new Commands(metadata.getPostCommands());
        return model;
    }

    public PatchMetadata toPatchMetadata() {
        PatchMetadataBuilder builder = new PatchMetadataBuilder().patchId(PatchId.fromString(this.patchId));
        if (this.roles != null) {
            builder.roles(this.roles.getRoles());
        }
        if (this.oneoffId != null) {
            builder.oneoffId(PatchId.fromString(this.oneoffId));
        }
        if (this.dependencies != null) {
            for (String auxid : this.dependencies.getDependencies()) {
                builder.dependencies(PatchId.fromString(auxid));
            }
        }
        if (this.postCommands != null) {
            builder.postCommands(this.postCommands.getCommands());
        }
        return builder.build();
    }

    public String getPatchId() {
        return this.patchId;
    }

    @XmlElement(name="patchId")
    public void setPatchId(String patchId) {
        this.patchId = patchId;
    }

    public String getOneoffId() {
        return this.oneoffId;
    }

    @XmlElement(name="oneoffId")
    public void setOneoffId(String oneoffId) {
        this.oneoffId = oneoffId;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    @XmlElement(name="dependencies")
    public void setDependencies(Dependencies dependencies) {
        this.dependencies = dependencies;
    }

    public Commands getPostCommands() {
        return this.postCommands;
    }

    @XmlElement(name="post-commands")
    public void setPostCommands(Commands postCommands) {
        this.postCommands = postCommands;
    }

    @XmlType
    public static class Commands {
        private List<String> commands;

        public Commands() {
        }

        public Commands(List<String> commands) {
            this.commands = new ArrayList<String>(commands);
        }

        public List<String> getCommands() {
            return this.commands;
        }

        @XmlElement(name="command")
        public void setCommands(List<String> commands) {
            this.commands = commands;
        }
    }

    @XmlType
    public static class Dependencies {
        private Set<String> patchIds;

        public Dependencies() {
        }

        public Dependencies(Set<PatchId> dependencies) {
            this.patchIds = new LinkedHashSet<String>();
            for (PatchId aux : dependencies) {
                this.patchIds.add(aux.toString());
            }
        }

        public Set<String> getDependencies() {
            return this.patchIds;
        }

        @XmlElement(name="patchId")
        void setDependencies(Set<String> patchIds) {
            this.patchIds = patchIds;
        }
    }

    @XmlType
    public static class Roles {
        private Set<String> roles;

        public Roles() {
        }

        public Roles(Set<String> roles) {
            this.roles = new LinkedHashSet<String>(roles);
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        @XmlElement(name="role")
        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }
    }
}

