/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.AtomEntry;
import com.splunk.AtomObject;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class AtomFeed
extends AtomObject {
    public ArrayList<AtomEntry> entries = new ArrayList();
    public String itemsPerPage = null;
    public String startIndex = null;
    public String totalResults = null;

    static AtomFeed create() {
        return new AtomFeed();
    }

    public static AtomFeed parseStream(InputStream input) {
        XMLStreamReader reader = AtomFeed.createReader(input);
        AtomFeed result = AtomFeed.parse(reader);
        try {
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    static AtomFeed parse(XMLStreamReader input) {
        AtomFeed feed = AtomFeed.create();
        feed.load(input, "feed");
        return feed;
    }

    @Override
    void init(XMLStreamReader reader) {
        assert (reader.isStartElement());
        String name = reader.getLocalName();
        if (name.equals("entry")) {
            AtomEntry entry = AtomEntry.parse(reader);
            this.entries.add(entry);
        } else if (name.equals("messages")) {
            this.parseEnd(reader);
        } else if (name.equals("totalResults")) {
            this.totalResults = this.parseText(reader);
        } else if (name.equals("itemsPerPage")) {
            this.itemsPerPage = this.parseText(reader);
        } else if (name.equals("startIndex")) {
            this.startIndex = this.parseText(reader);
        } else {
            super.init(reader);
        }
    }
}

