/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.Input;
import com.splunk.InputKind;
import com.splunk.Service;
import java.util.Map;

public class WindowsWmiInput
extends Input {
    WindowsWmiInput(Service service, String path) {
        super(service, path);
    }

    public String getClasses() {
        return this.getString("classes");
    }

    public String[] getFields() {
        return this.getStringArray("fields", null);
    }

    public String getIndex() {
        return this.getString("index", null);
    }

    public String[] getInstances() {
        return this.getStringArray("instances", null);
    }

    public int getInterval() {
        return this.getInteger("interval");
    }

    @Override
    public InputKind getKind() {
        return InputKind.WindowsWmi;
    }

    public String getLookupHost() {
        return this.getString("lookup_host");
    }

    public String getLocalName() {
        return this.getString("name");
    }

    public String getServers() {
        return this.getString("server", null);
    }

    public String getWql() {
        return this.getString("wql");
    }

    public void setClasses(String classes) {
        this.setCacheValue("classes", classes);
    }

    public void setDisabled(boolean disabled) {
        this.setCacheValue("disabled", disabled);
    }

    public void setFields(String[] fields) {
        this.setCacheValue("fields", fields);
    }

    public void setFields(String field) {
        this.setCacheValue("fields", new String[]{field});
    }

    public void setIndex(String index) {
        this.setCacheValue("index", index);
    }

    public void setInstances(String[] instances) {
        this.setCacheValue("instances", instances);
    }

    public void setInstances(String instance) {
        this.setCacheValue("instances", new String[]{instance});
    }

    public void setInterval(int interval) {
        this.setCacheValue("interval", interval);
    }

    public void setLookupHost(String lookup_host) {
        this.setCacheValue("lookup_host", lookup_host);
    }

    public void setServers(String servers) {
        this.setCacheValue("server", servers);
    }

    @Override
    public void update(Map<String, Object> args) {
        if (!args.containsKey("classes")) {
            args = Args.create(args).add("classes", this.getClasses());
        }
        if (!args.containsKey("interval")) {
            args = Args.create(args).add("interval", this.getInterval());
        }
        if (!args.containsKey("lookup_host")) {
            args = Args.create(args).add("lookup_host", this.getLookupHost());
        }
        super.update(args);
    }

    @Override
    public void update() {
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("classes")) {
            this.setCacheValue("classes", this.getClasses());
        }
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("interval")) {
            this.setCacheValue("interval", this.getInterval());
        }
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("lookup_host")) {
            this.setCacheValue("lookup_host", this.getLookupHost());
        }
        super.update();
    }
}

