/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.processor;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.hystrix.processor.HystrixProcessor;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.HystrixDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;

public class HystrixProcessorFactory
implements ProcessorFactory {
    public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
        return null;
    }

    public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
        if (definition instanceof HystrixDefinition) {
            boolean fallbackViaNetwork;
            HystrixDefinition cb = (HystrixDefinition)definition;
            Processor processor = cb.createChildProcessor(routeContext, true);
            Processor fallback = null;
            if (cb.getOnFallback() != null) {
                fallback = cb.getOnFallback().createProcessor(routeContext);
            }
            HystrixConfigurationDefinition config = cb.getHystrixConfiguration();
            HystrixConfigurationDefinition configRef = null;
            if (cb.getHystrixConfigurationRef() != null) {
                configRef = (HystrixConfigurationDefinition)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)cb.getHystrixConfigurationRef(), HystrixConfigurationDefinition.class);
            }
            String id = cb.idOrCreate(routeContext.getCamelContext().getNodeIdFactory());
            String groupKey = null;
            String threadPoolKey = null;
            if (configRef != null) {
                groupKey = configRef.getGroupKey();
                threadPoolKey = configRef.getThreadPoolKey();
            }
            if (config != null && config.getGroupKey() != null) {
                groupKey = config.getGroupKey();
                threadPoolKey = config.getThreadPoolKey();
            }
            if (groupKey == null) {
                groupKey = "CamelHystrix";
            }
            if (threadPoolKey == null) {
                threadPoolKey = groupKey;
            }
            HystrixCommandKey hcCommandKey = HystrixCommandKey.Factory.asKey((String)id);
            HystrixCommandKey hcFallbackCommandKey = HystrixCommandKey.Factory.asKey((String)(id + "-fallback"));
            HystrixCommandGroupKey hcGroupKey = HystrixCommandGroupKey.Factory.asKey((String)groupKey);
            HystrixThreadPoolKey tpKey = HystrixThreadPoolKey.Factory.asKey((String)threadPoolKey);
            HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hcGroupKey).andCommandKey(hcCommandKey).andThreadPoolKey(tpKey);
            HystrixCommandProperties.Setter commandSetter = HystrixCommandProperties.Setter();
            setter.andCommandPropertiesDefaults(commandSetter);
            HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
            setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
            if (configRef != null) {
                this.configureHystrix(commandSetter, threadPoolSetter, configRef);
            }
            if (config != null) {
                this.configureHystrix(commandSetter, threadPoolSetter, config);
            }
            HystrixCommand.Setter fallbackSetter = null;
            boolean bl = fallbackViaNetwork = cb.getOnFallback() != null && cb.getOnFallback().isFallbackViaNetwork();
            if (fallbackViaNetwork) {
                HystrixThreadPoolKey tpFallbackKey = HystrixThreadPoolKey.Factory.asKey((String)(threadPoolKey + "-fallback"));
                fallbackSetter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hcGroupKey).andCommandKey(hcFallbackCommandKey).andThreadPoolKey(tpFallbackKey);
                HystrixCommandProperties.Setter commandFallbackSetter = HystrixCommandProperties.Setter();
                fallbackSetter.andCommandPropertiesDefaults(commandFallbackSetter);
                HystrixThreadPoolProperties.Setter fallbackThreadPoolSetter = HystrixThreadPoolProperties.Setter();
                fallbackSetter.andThreadPoolPropertiesDefaults(fallbackThreadPoolSetter);
                if (configRef != null) {
                    this.configureHystrix(commandFallbackSetter, fallbackThreadPoolSetter, configRef);
                }
                if (config != null) {
                    this.configureHystrix(commandFallbackSetter, fallbackThreadPoolSetter, config);
                }
            }
            return new HystrixProcessor(hcGroupKey, hcCommandKey, hcFallbackCommandKey, setter, fallbackSetter, processor, fallback, fallbackViaNetwork);
        }
        return null;
    }

    private void configureHystrix(HystrixCommandProperties.Setter command, HystrixThreadPoolProperties.Setter threadPool, HystrixConfigurationDefinition config) {
        if (config.getCircuitBreakerEnabled() != null) {
            command.withCircuitBreakerEnabled(config.getCircuitBreakerEnabled().booleanValue());
        }
        if (config.getCircuitBreakerErrorThresholdPercentage() != null) {
            command.withCircuitBreakerErrorThresholdPercentage(config.getCircuitBreakerErrorThresholdPercentage().intValue());
        }
        if (config.getCircuitBreakerForceClosed() != null) {
            command.withCircuitBreakerForceClosed(config.getCircuitBreakerForceClosed().booleanValue());
        }
        if (config.getCircuitBreakerForceOpen() != null) {
            command.withCircuitBreakerForceOpen(config.getCircuitBreakerForceOpen().booleanValue());
        }
        if (config.getCircuitBreakerRequestVolumeThreshold() != null) {
            command.withCircuitBreakerRequestVolumeThreshold(config.getCircuitBreakerRequestVolumeThreshold().intValue());
        }
        if (config.getCircuitBreakerSleepWindowInMilliseconds() != null) {
            command.withCircuitBreakerSleepWindowInMilliseconds(config.getCircuitBreakerSleepWindowInMilliseconds().intValue());
        }
        if (config.getExecutionIsolationSemaphoreMaxConcurrentRequests() != null) {
            command.withExecutionIsolationSemaphoreMaxConcurrentRequests(config.getExecutionIsolationSemaphoreMaxConcurrentRequests().intValue());
        }
        if (config.getExecutionIsolationStrategy() != null) {
            command.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.valueOf((String)config.getExecutionIsolationStrategy()));
        }
        if (config.getExecutionIsolationThreadInterruptOnTimeout() != null) {
            command.withExecutionIsolationThreadInterruptOnTimeout(config.getExecutionIsolationThreadInterruptOnTimeout().booleanValue());
        }
        if (config.getExecutionTimeoutInMilliseconds() != null) {
            command.withExecutionTimeoutInMilliseconds(config.getExecutionTimeoutInMilliseconds().intValue());
        }
        if (config.getExecutionTimeoutEnabled() != null) {
            command.withExecutionTimeoutEnabled(config.getExecutionTimeoutEnabled().booleanValue());
        }
        if (config.getFallbackIsolationSemaphoreMaxConcurrentRequests() != null) {
            command.withFallbackIsolationSemaphoreMaxConcurrentRequests(config.getFallbackIsolationSemaphoreMaxConcurrentRequests().intValue());
        }
        if (config.getFallbackEnabled() != null) {
            command.withFallbackEnabled(config.getFallbackEnabled().booleanValue());
        }
        if (config.getMetricsHealthSnapshotIntervalInMilliseconds() != null) {
            command.withMetricsHealthSnapshotIntervalInMilliseconds(config.getMetricsHealthSnapshotIntervalInMilliseconds().intValue());
        }
        if (config.getMetricsRollingPercentileBucketSize() != null) {
            command.withMetricsRollingPercentileBucketSize(config.getMetricsRollingPercentileBucketSize().intValue());
        }
        if (config.getMetricsRollingPercentileEnabled() != null) {
            command.withMetricsRollingPercentileEnabled(config.getMetricsRollingPercentileEnabled().booleanValue());
        }
        if (config.getMetricsRollingPercentileWindowInMilliseconds() != null) {
            command.withMetricsRollingPercentileWindowInMilliseconds(config.getMetricsRollingPercentileWindowInMilliseconds().intValue());
        }
        if (config.getMetricsRollingPercentileWindowBuckets() != null) {
            command.withMetricsRollingPercentileWindowBuckets(config.getMetricsRollingPercentileWindowBuckets().intValue());
        }
        if (config.getMetricsRollingStatisticalWindowInMilliseconds() != null) {
            command.withMetricsRollingStatisticalWindowInMilliseconds(config.getMetricsRollingStatisticalWindowInMilliseconds().intValue());
        }
        if (config.getMetricsRollingStatisticalWindowBuckets() != null) {
            command.withMetricsRollingStatisticalWindowBuckets(config.getMetricsRollingStatisticalWindowBuckets().intValue());
        }
        if (config.getRequestLogEnabled() != null) {
            command.withRequestLogEnabled(config.getRequestLogEnabled().booleanValue());
        }
        if (config.getCorePoolSize() != null) {
            threadPool.withCoreSize(config.getCorePoolSize().intValue());
        }
        if (config.getKeepAliveTime() != null) {
            threadPool.withKeepAliveTimeMinutes(config.getKeepAliveTime().intValue());
        }
        if (config.getMaxQueueSize() != null) {
            threadPool.withMaxQueueSize(config.getMaxQueueSize().intValue());
        }
        if (config.getQueueSizeRejectionThreshold() != null) {
            threadPool.withQueueSizeRejectionThreshold(config.getQueueSizeRejectionThreshold().intValue());
        }
        if (config.getThreadPoolRollingNumberStatisticalWindowInMilliseconds() != null) {
            threadPool.withMetricsRollingStatisticalWindowInMilliseconds(config.getThreadPoolRollingNumberStatisticalWindowInMilliseconds().intValue());
        }
        if (config.getThreadPoolRollingNumberStatisticalWindowBuckets() != null) {
            threadPool.withMetricsRollingStatisticalWindowBuckets(config.getThreadPoolRollingNumberStatisticalWindowBuckets().intValue());
        }
    }
}

