/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.TwitterEndpointPolling;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.streaming.AbstractStreamingConsumer;
import org.apache.camel.impl.ScheduledPollConsumer;

public class TwitterConsumerPolling
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    private final TwitterConsumer twitter4jConsumer;

    public TwitterConsumerPolling(TwitterEndpointPolling endpoint, Processor processor, TwitterConsumer twitter4jConsumer) {
        super((Endpoint)endpoint, processor);
        this.setDelay(60000L);
        this.twitter4jConsumer = twitter4jConsumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.twitter4jConsumer instanceof AbstractStreamingConsumer) {
            ((AbstractStreamingConsumer)this.twitter4jConsumer).start();
        }
    }

    protected void doStop() throws Exception {
        if (this.twitter4jConsumer instanceof AbstractStreamingConsumer) {
            ((AbstractStreamingConsumer)this.twitter4jConsumer).stop();
        }
        super.doStop();
    }

    protected int poll() throws Exception {
        int index;
        List<Exchange> exchanges = this.twitter4jConsumer.pollConsume();
        for (index = 0; index < exchanges.size(); ++index) {
            this.getProcessor().process(exchanges.get(index));
        }
        return index;
    }
}

