/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.AbstractRedisProcessorCreator;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.RedisClient;

public final class HashesRedisProcessorsCreator
extends AbstractRedisProcessorCreator {
    Map<Command, Processor> getProcessors(RedisClient redisClient, ExchangeConverter exchangeConverter) {
        this.bind(Command.HDEL, exchange -> redisClient.hdel(exchangeConverter.getKey(exchange), exchangeConverter.getField(exchange)));
        this.bind(Command.HEXISTS, this.wrap(exchange -> redisClient.hexists(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getField((Exchange)exchange))));
        this.bind(Command.HGET, this.wrap(exchange -> redisClient.hget(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getField((Exchange)exchange))));
        this.bind(Command.HGETALL, this.wrap(exchange -> redisClient.hgetAll(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.HINCRBY, this.wrap(exchange -> redisClient.hincrBy(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getField((Exchange)exchange), exchangeConverter.getValueAsLong((Exchange)exchange))));
        this.bind(Command.HKEYS, this.wrap(exchange -> redisClient.hkeys(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.HLEN, this.wrap(exchange -> redisClient.hlen(exchangeConverter.getKey((Exchange)exchange))));
        this.bind(Command.HMGET, this.wrap(exchange -> redisClient.hmget(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getFields((Exchange)exchange))));
        this.bind(Command.HMSET, exchange -> redisClient.hmset(exchangeConverter.getKey(exchange), exchangeConverter.getValuesAsMap(exchange)));
        this.bind(Command.HSET, exchange -> redisClient.hset(exchangeConverter.getKey(exchange), exchangeConverter.getField(exchange), exchangeConverter.getValue(exchange)));
        this.bind(Command.HSETNX, this.wrap(exchange -> redisClient.hsetnx(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getField((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.HVALS, this.wrap(exchange -> redisClient.hvals(exchangeConverter.getKey((Exchange)exchange))));
        return this.result;
    }
}

