/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.util.Assert;

public class JobParametersBuilder {
    private final Map<String, JobParameter> parameterMap;

    public JobParametersBuilder() {
        this.parameterMap = new LinkedHashMap<String, JobParameter>();
    }

    public JobParametersBuilder(JobParameters jobParameters) {
        this.parameterMap = new LinkedHashMap<String, JobParameter>(jobParameters.getParameters());
    }

    public JobParametersBuilder(Properties properties) {
        this.parameterMap = new LinkedHashMap<String, JobParameter>();
        if (properties != null) {
            for (Map.Entry<Object, Object> curProperty : properties.entrySet()) {
                this.parameterMap.put((String)curProperty.getKey(), new JobParameter((String)curProperty.getValue(), false));
            }
        }
    }

    public JobParametersBuilder addString(String key, String parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addString(String key, String parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParametersBuilder addDate(String key, Date parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addDate(String key, Date parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParametersBuilder addLong(String key, Long parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addLong(String key, Long parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParametersBuilder addDouble(String key, Double parameter) {
        this.parameterMap.put(key, new JobParameter(parameter, true));
        return this;
    }

    public JobParametersBuilder addDouble(String key, Double parameter, boolean identifying) {
        this.parameterMap.put(key, new JobParameter(parameter, identifying));
        return this;
    }

    public JobParameters toJobParameters() {
        return new JobParameters(this.parameterMap);
    }

    public JobParametersBuilder addParameter(String key, JobParameter jobParameter) {
        Assert.notNull((Object)jobParameter, (String)"JobParameter must not be null");
        this.parameterMap.put(key, jobParameter);
        return this;
    }
}

